"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.entityTypesRt = exports.entityTypeRt = exports.entityColumnIdsRt = exports.defaultEntityTypes = exports.defaultEntitySortField = exports.defaultEntityDefinitions = exports.MAX_NUMBER_OF_ENTITIES = exports.ENTITIES_LATEST_ALIAS = void 0;
var _entitiesSchema = require("@kbn/entities-schema");
var _common = require("@kbn/observability-shared-plugin/common");
var _Either = require("fp-ts/lib/Either");
var t = _interopRequireWildcard(require("io-ts"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const entityTypeRt = exports.entityTypeRt = t.union([t.literal('service'), t.literal('host'), t.literal('container')]);
const entityColumnIdsRt = exports.entityColumnIdsRt = t.union([t.literal(_common.ENTITY_DISPLAY_NAME), t.literal(_common.ENTITY_LAST_SEEN), t.literal(_common.ENTITY_TYPE), t.literal('alertsCount')]);
const defaultEntitySortField = exports.defaultEntitySortField = 'alertsCount';
const MAX_NUMBER_OF_ENTITIES = exports.MAX_NUMBER_OF_ENTITIES = 500;
const ENTITIES_LATEST_ALIAS = exports.ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: '*',
  dataset: _entitiesSchema.ENTITY_LATEST
});
const BUILTIN_SERVICES_FROM_ECS_DATA = 'builtin_services_from_ecs_data';
const BUILTIN_HOSTS_FROM_ECS_DATA = 'builtin_hosts_from_ecs_data';
const BUILTIN_CONTAINERS_FROM_ECS_DATA = 'builtin_containers_from_ecs_data';
const defaultEntityDefinitions = exports.defaultEntityDefinitions = [BUILTIN_SERVICES_FROM_ECS_DATA, BUILTIN_HOSTS_FROM_ECS_DATA, BUILTIN_CONTAINERS_FROM_ECS_DATA];
const defaultEntityTypes = exports.defaultEntityTypes = ['service', 'host', 'container'];
const entityArrayRt = t.array(entityTypeRt);
const entityTypesRt = exports.entityTypesRt = new t.Type('entityTypesRt', entityArrayRt.is, (input, context) => {
  if (typeof input === 'string') {
    const arr = input.split(',');
    const validation = entityArrayRt.decode(arr);
    if ((0, _Either.isRight)(validation)) {
      return t.success(validation.right);
    }
  } else if (Array.isArray(input)) {
    const validation = entityArrayRt.decode(input);
    if ((0, _Either.isRight)(validation)) {
      return t.success(validation.right);
    }
  }
  return t.failure(input, context);
}, arr => arr.join());

/**
 * These types are based on service, host and container from the built in definition.
 */