"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenObjectsList = flattenObjectsList;
exports.generateFields = generateFields;
exports.merge = merge;
exports.mergeSamples = mergeSamples;
exports.prefixSamples = prefixSamples;
var yaml = _interopRequireWildcard(require("js-yaml"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/* eslint-disable @typescript-eslint/no-explicit-any */

// Given a graph state, it collects the rawSamples (array of JSON strings) and prefixes them with the packageName and dataStreamName, returning an array of prefixed JSON strings.
function prefixSamples(state) {
  const modifiedSamples = [];
  const rawSamples = state.rawSamples;
  const packageName = state.packageName;
  const dataStreamName = state.dataStreamName;
  for (const sample of rawSamples) {
    const sampleObj = JSON.parse(sample);
    const newObj = {
      [packageName]: {
        [dataStreamName]: sampleObj
      }
    };
    const modifiedSample = JSON.stringify(newObj);
    modifiedSamples.push(modifiedSample);
  }
  return modifiedSamples;
}
function determineType(value) {
  if (typeof value === 'object' && value !== null) {
    if (Array.isArray(value)) {
      return 'group';
    }
    return 'group';
  }
  if (typeof value === 'string') {
    return 'keyword';
  }
  if (typeof value === 'boolean') {
    return 'boolean';
  }
  if (typeof value === 'number') {
    return 'long';
  }
  return 'keyword'; // Default type for null or other undetermined types
}
function recursiveParse(obj, path) {
  if (typeof obj === 'object' && obj !== null) {
    if (Array.isArray(obj)) {
      // Assume list elements are uniform and use the first element as representative
      if (obj.length > 0) {
        return recursiveParse(obj[0], path);
      }
      return {
        name: path[path.length - 1],
        type: 'group',
        fields: []
      };
    }
    const fields = [];
    for (const [key, value] of Object.entries(obj)) {
      fields.push(recursiveParse(value, path.concat(key)));
    }
    return {
      name: path[path.length - 1],
      type: 'group',
      fields
    };
  }
  return {
    name: path[path.length - 1],
    type: determineType(obj)
  };
}
function generateFields(mergedDocs) {
  const ecsTopKeysSet = new Set(['@timestamp', 'agent', 'as', 'base', 'client', 'cloud', 'code_signature', 'container', 'data_stream', 'destination', 'device', 'dll', 'dns', 'ecs', 'elf', 'email', 'error', 'event', 'faas', 'file', 'geo', 'group', 'hash', 'host', 'http', 'interface', 'labels', 'log', 'macho', 'message', 'network', 'observer', 'orchestrator', 'organization', 'os', 'package', 'pe', 'process', 'registry', 'related', 'risk', 'rule', 'server', 'service', 'source', 'tags', 'threat', 'tls', 'tracing', 'url', 'user', 'user_agent', 'vlan', 'volume', 'vulnerability', 'x509']);
  const doc = JSON.parse(mergedDocs);
  const fieldsStructure = Object.keys(doc).filter(key => !ecsTopKeysSet.has(key)).map(key => recursiveParse(doc[key], [key]));
  return yaml.safeDump(fieldsStructure, {
    sortKeys: false
  });
}
function merge(target, source) {
  const filteredTarget = filterOwnProperties(target);
  for (const [key, sourceValue] of Object.entries(source)) {
    if (!isBuiltInProperties(key, source)) {
      const targetValue = filteredTarget[key];
      if (Array.isArray(sourceValue)) {
        // Directly assign arrays
        filteredTarget[key] = sourceValue;
      } else if (isObject(sourceValue) && !Array.isArray(targetValue)) {
        if (!isObject(targetValue) || isEmptyValue(targetValue)) {
          filteredTarget[key] = merge({}, sourceValue);
        } else {
          filteredTarget[key] = merge(targetValue, sourceValue);
        }
      } else if (!(key in filteredTarget) || isEmptyValue(targetValue) && !isEmptyValue(sourceValue)) {
        filteredTarget[key] = sourceValue;
      }
    }
  }
  return filteredTarget;
}
function isEmptyValue(value) {
  if (value == null) return true;
  if (isObject(value)) {
    if (Array.isArray(value)) return value.length === 0;
    return value && Object.keys(value).length === 0;
  }
  return false;
}
function isObject(value) {
  return typeof value === 'object' && value !== null;
}
function isBuiltInProperties(key, obj) {
  return key === 'constructor' || !Object.prototype.hasOwnProperty.call(obj, key);
}
function filterOwnProperties(obj) {
  const ownProps = {};
  for (const key of Object.getOwnPropertyNames(obj)) {
    if (!isBuiltInProperties(key, obj)) {
      ownProps[key] = obj[key];
    }
  }
  return ownProps;
}
function mergeSamples(objects) {
  let result = {};
  for (const obj of objects) {
    let sample = obj;
    if (typeof obj === 'string') {
      sample = JSON.parse(obj);
    }
    result = merge(result, sample);
  }
  return JSON.stringify(result, null, 2);
}
function flattenObjectsList(obj) {
  const result = [];
  flattenObject(obj, '', '.', result);
  return sortArrayOfObjects(result);
}
function flattenObject(obj, parentKey = '', separator = '.', result) {
  obj.forEach(element => {
    if (element.name) {
      const newKey = parentKey ? `${parentKey}${separator}${element.name}` : element.name;
      if (element.fields && Array.isArray(element.fields)) {
        flattenObject(element.fields, newKey, separator, result);
      } else {
        result.push({
          name: newKey,
          type: element.type,
          description: element.description
        });
      }
    }
  });
}
function sortArrayOfObjects(objectsArray) {
  return objectsArray.sort((a, b) => {
    return a.name.localeCompare(b.name);
  });
}