"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLLMType = exports.getLLMClass = void 0;
var _server = require("@kbn/langchain/server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getLLMType = actionTypeId => {
  const llmTypeDictionary = {
    [`.gen-ai`]: `openai`,
    [`.bedrock`]: `bedrock`,
    [`.gemini`]: `gemini`
  };
  return llmTypeDictionary[actionTypeId];
};
exports.getLLMType = getLLMType;
const getLLMClass = llmType => llmType === 'openai' ? _server.ActionsClientChatOpenAI : llmType === 'bedrock' ? _server.ActionsClientBedrockChatModel : llmType === 'gemini' ? _server.ActionsClientGeminiChatModel : _server.ActionsClientSimpleChatModel;
exports.getLLMClass = getLLMClass;