"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerPipelineRoutes = registerPipelineRoutes;
var _common = require("../../common");
var _constants = require("../constants");
var _pipeline = require("../util/pipeline");
var _route_validation = require("../util/route_validation");
var _with_availability = require("./with_availability");
var _errors = require("../lib/errors");
var _routes_util = require("./routes_util");
var _constants2 = require("../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerPipelineRoutes(router) {
  router.versioned.post({
    path: _common.CHECK_PIPELINE_PATH,
    access: 'internal',
    options: {
      timeout: {
        idleSocket: _constants.ROUTE_HANDLER_TIMEOUT
      }
    }
  }).addVersion({
    version: '1',
    validate: {
      request: {
        body: (0, _route_validation.buildRouteValidationWithZod)(_common.CheckPipelineRequestBody)
      }
    }
  }, (0, _with_availability.withAvailability)(async (context, req, res) => {
    const {
      rawSamples,
      pipeline
    } = req.body;
    const services = await context.resolve(['core']);
    const {
      client
    } = services.core.elasticsearch;
    try {
      const {
        errors,
        pipelineResults
      } = await (0, _pipeline.testPipeline)(rawSamples, pipeline, client);
      if (errors !== null && errors !== void 0 && errors.length) {
        return res.badRequest({
          body: JSON.stringify(errors)
        });
      }
      return res.ok({
        body: _common.CheckPipelineResponse.parse({
          results: {
            docs: pipelineResults
          }
        })
      });
    } catch (err) {
      try {
        (0, _routes_util.handleCustomErrors)(err, _constants2.GenerationErrorCode.RECURSION_LIMIT);
      } catch (e) {
        if ((0, _errors.isErrorThatHandlesItsOwnResponse)(e)) {
          return e.sendResponse(res);
        }
      }
      return res.badRequest({
        body: err
      });
    }
  }));
}