"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReadme = createReadme;
var _nunjucks = require("nunjucks");
var _path = require("path");
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createReadme(packageDir, integrationName, fields) {
  createPackageReadme(packageDir, integrationName, fields);
  createBuildReadme(packageDir, integrationName, fields);
}
function createPackageReadme(packageDir, integrationName, fields) {
  const dirPath = (0, _path.join)(packageDir, 'docs/');
  // The readme nunjucks template files should be named in the format `somename_readme.md.njk` and not just `readme.md.njk`
  // since any file with `readme.*` pattern is skipped in build process in buildkite.
  createReadmeFile(dirPath, 'package_readme.md.njk', integrationName, fields);
}
function createBuildReadme(packageDir, integrationName, fields) {
  const dirPath = (0, _path.join)(packageDir, '_dev/build/docs/');
  createReadmeFile(dirPath, 'build_readme.md.njk', integrationName, fields);
}
function createReadmeFile(targetDir, templateName, integrationName, fields) {
  (0, _util.ensureDirSync)(targetDir);
  const templatesPath = (0, _path.join)(__dirname, '../templates');
  const env = new _nunjucks.Environment(new _nunjucks.FileSystemLoader(templatesPath), {
    autoescape: false
  });
  const template = env.getTemplate(templateName);
  const renderedTemplate = template.render({
    package_name: integrationName,
    fields
  });
  (0, _util.createSync)((0, _path.join)(targetDir, 'README.md'), renderedTemplate);
}