"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createPipeline = createPipeline;
var _path = require("path");
var _jsYaml = _interopRequireDefault(require("js-yaml"));
var _util = require("../util");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function createPipeline(specificDataStreamDir, pipeline) {
  const filePath = (0, _path.join)(specificDataStreamDir, 'elasticsearch/ingest_pipeline/default.yml');
  const yamlContent = `---\n${_jsYaml.default.safeDump(pipeline, {
    sortKeys: false
  })}`;
  (0, _util.createSync)(filePath, yamlContent);
}