"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUnstructuredValidate = handleUnstructuredValidate;
var _util = require("../../util");
var _processors = require("../../util/processors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleUnstructuredValidate({
  state,
  client
}) {
  const grokPatterns = state.grokPatterns;
  const grokProcessor = (0, _processors.createGrokProcessor)(grokPatterns);
  const pipeline = {
    processors: grokProcessor,
    on_failure: [(0, _processors.createPassthroughFailureProcessor)()]
  };
  const packageName = state.packageName;
  const dataStreamName = state.dataStreamName;
  const {
    pipelineResults,
    errors
  } = await (0, _util.testPipeline)(state.logSamples, pipeline, client);
  if (errors.length > 0) {
    return {
      errors,
      lastExecutedChain: 'unstructuredValidate'
    };
  }
  const jsonSamples = pipelineResults.map(log => log[packageName]).map(log => log[dataStreamName]).map(log => JSON.stringify(log));
  const additionalProcessors = state.additionalProcessors;
  additionalProcessors.push(grokProcessor[0]);
  return {
    jsonSamples,
    additionalProcessors,
    errors: [],
    lastExecutedChain: 'unstructuredValidate'
  };
}