"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUnstructured = handleUnstructured;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleUnstructured({
  state,
  model,
  client
}) {
  const grokMainGraph = _prompts.GROK_MAIN_PROMPT.pipe(model).pipe(new _output_parsers.JsonOutputParser());

  // Pick logSamples if there was no header detected.
  const samples = state.logSamples;
  const pattern = await grokMainGraph.invoke({
    packageName: state.packageName,
    dataStreamName: state.dataStreamName,
    samples: samples[0],
    ex_answer: JSON.stringify(_constants.GROK_EXAMPLE_ANSWER, null, 2)
  });
  return {
    grokPatterns: pattern.grok_patterns,
    lastExecutedChain: 'handleUnstructured'
  };
}