"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleUnstructuredError = handleUnstructuredError;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleUnstructuredError({
  state,
  model
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const grokErrorGraph = _prompts.GROK_ERROR_PROMPT.pipe(model).pipe(outputParser);
  const currentPatterns = state.grokPatterns;
  const pattern = await grokErrorGraph.invoke({
    packageName: state.packageName,
    dataStreamName: state.dataStreamName,
    current_pattern: JSON.stringify(currentPatterns, null, 2),
    errors: JSON.stringify(state.errors, null, 2),
    ex_answer: JSON.stringify(_constants.GROK_ERROR_EXAMPLE_ANSWER, null, 2)
  });
  return {
    grokPatterns: pattern.grok_patterns,
    lastExecutedChain: 'unstructuredError'
  };
}