"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLogFormatDetectionGraph = getLogFormatDetectionGraph;
var _langgraph = require("@langchain/langgraph");
var _constants = require("./constants");
var _detection = require("./detection");
var _csv = require("../csv/csv");
var _graph = require("../kv/graph");
var _constants2 = require("../../constants");
var _graph2 = require("../unstructured/graph");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const graphState = {
  lastExecutedChain: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamName: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  packageTitle: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  dataStreamTitle: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  logSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  jsonSamples: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  },
  exAnswer: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ''
  },
  finalized: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  samplesFormat: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({
      name: 'unsupported'
    })
  },
  header: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => false
  },
  ecsVersion: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => '8.11.0'
  },
  results: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => ({})
  },
  additionalProcessors: {
    value: (x, y) => y !== null && y !== void 0 ? y : x,
    default: () => []
  }
};
function modelInput({
  state
}) {
  return {
    exAnswer: JSON.stringify(_constants.EX_ANSWER_LOG_TYPE, null, 2),
    finalized: false,
    lastExecutedChain: 'modelInput'
  };
}
function modelOutput({
  state
}) {
  return {
    finalized: true,
    lastExecutedChain: 'modelOutput',
    results: {
      samplesFormat: state.samplesFormat,
      parsedSamples: state.jsonSamples,
      additionalProcessors: state.additionalProcessors
    }
  };
}
function logFormatRouter({
  state
}) {
  if (state.samplesFormat.name === _constants2.LogFormat.STRUCTURED) {
    return 'structured';
  }
  if (state.samplesFormat.name === _constants2.LogFormat.UNSTRUCTURED) {
    return 'unstructured';
  }
  if (state.samplesFormat.name === _constants2.LogFormat.CSV) {
    return 'csv';
  }
  return 'unsupported';
}
async function getLogFormatDetectionGraph({
  model,
  client
}) {
  const workflow = new _langgraph.StateGraph({
    channels: graphState
  }).addNode('modelInput', state => modelInput({
    state
  })).addNode('modelOutput', state => modelOutput({
    state
  })).addNode('handleLogFormatDetection', state => (0, _detection.handleLogFormatDetection)({
    state,
    model,
    client
  })).addNode('handleKVGraph', await (0, _graph.getKVGraph)({
    model,
    client
  })).addNode('handleUnstructuredGraph', await (0, _graph2.getUnstructuredGraph)({
    model,
    client
  })).addNode('handleCSV', state => (0, _csv.handleCSV)({
    state,
    model,
    client
  })).addEdge(_langgraph.START, 'modelInput').addEdge('modelInput', 'handleLogFormatDetection').addEdge('handleKVGraph', 'modelOutput').addEdge('handleUnstructuredGraph', 'modelOutput').addEdge('handleCSV', 'modelOutput').addEdge('modelOutput', _langgraph.END).addConditionalEdges('handleLogFormatDetection', state => logFormatRouter({
    state
  }), {
    structured: 'handleKVGraph',
    unstructured: 'handleUnstructuredGraph',
    csv: 'handleCSV',
    unsupported: 'modelOutput'
  });
  const compiledLogFormatDetectionGraph = workflow.compile().withConfig({
    runName: 'Log Format'
  });
  return compiledLogFormatDetectionGraph;
}