"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handleHeader = handleHeader;
var _output_parsers = require("@langchain/core/output_parsers");
var _prompts = require("./prompts");
var _constants = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function handleHeader({
  state,
  model,
  client
}) {
  const outputParser = new _output_parsers.JsonOutputParser();
  const kvHeaderGraph = _prompts.KV_HEADER_PROMPT.pipe(model).pipe(outputParser);
  const pattern = await kvHeaderGraph.invoke({
    samples: state.logSamples,
    packageName: state.packageName,
    dataStreamName: state.dataStreamName,
    ex_answer: JSON.stringify(_constants.KV_HEADER_EXAMPLE_ANSWER, null, 2)
  });
  return {
    grokPattern: pattern.grok_pattern,
    lastExecutedChain: 'kvHeader'
  };
}