"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ECS_TYPES = exports.ECS_RESERVED = exports.ECS_FIELDS = exports.ECS_EXAMPLE_ANSWER = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ECS_TYPES = exports.ECS_TYPES = {
  '@timestamp': 'date',
  'agent.build.original': 'keyword',
  'agent.ephemeral_id': 'keyword',
  'agent.id': 'keyword',
  'agent.name': 'keyword',
  'agent.type': 'keyword',
  'agent.version': 'keyword',
  'client.address': 'keyword',
  'client.as.number': 'long',
  'client.as.organization.name': 'keyword',
  'client.bytes': 'long',
  'client.domain': 'keyword',
  'client.geo.city_name': 'keyword',
  'client.geo.continent_code': 'keyword',
  'client.geo.continent_name': 'keyword',
  'client.geo.country_iso_code': 'keyword',
  'client.geo.country_name': 'keyword',
  'client.geo.location': 'geo_point',
  'client.geo.name': 'keyword',
  'client.geo.postal_code': 'keyword',
  'client.geo.region_iso_code': 'keyword',
  'client.geo.region_name': 'keyword',
  'client.geo.timezone': 'keyword',
  'client.ip': 'ip',
  'client.mac': 'keyword',
  'client.nat.ip': 'ip',
  'client.nat.port': 'long',
  'client.packets': 'long',
  'client.port': 'long',
  'client.registered_domain': 'keyword',
  'client.subdomain': 'keyword',
  'client.top_level_domain': 'keyword',
  'client.user.domain': 'keyword',
  'client.user.email': 'keyword',
  'client.user.full_name': 'keyword',
  'client.user.group.domain': 'keyword',
  'client.user.group.id': 'keyword',
  'client.user.group.name': 'keyword',
  'client.user.hash': 'keyword',
  'client.user.id': 'keyword',
  'client.user.name': 'keyword',
  'client.user.roles': 'keyword',
  'cloud.account.id': 'keyword',
  'cloud.account.name': 'keyword',
  'cloud.availability_zone': 'keyword',
  'cloud.instance.id': 'keyword',
  'cloud.instance.name': 'keyword',
  'cloud.machine.type': 'keyword',
  'cloud.origin.account.id': 'keyword',
  'cloud.origin.account.name': 'keyword',
  'cloud.origin.availability_zone': 'keyword',
  'cloud.origin.instance.id': 'keyword',
  'cloud.origin.instance.name': 'keyword',
  'cloud.origin.machine.type': 'keyword',
  'cloud.origin.project.id': 'keyword',
  'cloud.origin.project.name': 'keyword',
  'cloud.origin.provider': 'keyword',
  'cloud.origin.region': 'keyword',
  'cloud.origin.service.name': 'keyword',
  'cloud.project.id': 'keyword',
  'cloud.project.name': 'keyword',
  'cloud.provider': 'keyword',
  'cloud.region': 'keyword',
  'cloud.service.name': 'keyword',
  'cloud.target.account.id': 'keyword',
  'cloud.target.account.name': 'keyword',
  'cloud.target.availability_zone': 'keyword',
  'cloud.target.instance.id': 'keyword',
  'cloud.target.instance.name': 'keyword',
  'cloud.target.machine.type': 'keyword',
  'cloud.target.project.id': 'keyword',
  'cloud.target.project.name': 'keyword',
  'cloud.target.provider': 'keyword',
  'cloud.target.region': 'keyword',
  'cloud.target.service.name': 'keyword',
  'container.cpu.usage': 'scaled_float',
  'container.disk.read.bytes': 'long',
  'container.disk.write.bytes': 'long',
  'container.id': 'keyword',
  'container.image.hash.all': 'keyword',
  'container.image.name': 'keyword',
  'container.image.tag': 'keyword',
  'container.labels': 'object',
  'container.memory.usage': 'scaled_float',
  'container.name': 'keyword',
  'container.network.egress.bytes': 'long',
  'container.network.ingress.bytes': 'long',
  'container.runtime': 'keyword',
  'container.security_context.privileged': 'boolean',
  'destination.address': 'keyword',
  'destination.as.number': 'long',
  'destination.as.organization.name': 'keyword',
  'destination.bytes': 'long',
  'destination.domain': 'keyword',
  'destination.geo.city_name': 'keyword',
  'destination.geo.continent_code': 'keyword',
  'destination.geo.continent_name': 'keyword',
  'destination.geo.country_iso_code': 'keyword',
  'destination.geo.country_name': 'keyword',
  'destination.geo.location': 'geo_point',
  'destination.geo.name': 'keyword',
  'destination.geo.postal_code': 'keyword',
  'destination.geo.region_iso_code': 'keyword',
  'destination.geo.region_name': 'keyword',
  'destination.geo.timezone': 'keyword',
  'destination.ip': 'ip',
  'destination.mac': 'keyword',
  'destination.nat.ip': 'ip',
  'destination.nat.port': 'long',
  'destination.packets': 'long',
  'destination.port': 'long',
  'destination.registered_domain': 'keyword',
  'destination.subdomain': 'keyword',
  'destination.top_level_domain': 'keyword',
  'destination.user.domain': 'keyword',
  'destination.user.email': 'keyword',
  'destination.user.full_name': 'keyword',
  'destination.user.group.domain': 'keyword',
  'destination.user.group.id': 'keyword',
  'destination.user.group.name': 'keyword',
  'destination.user.hash': 'keyword',
  'destination.user.id': 'keyword',
  'destination.user.name': 'keyword',
  'destination.user.roles': 'keyword',
  'device.id': 'keyword',
  'device.manufacturer': 'keyword',
  'device.model.identifier': 'keyword',
  'device.model.name': 'keyword',
  'dll.code_signature.digest_algorithm': 'keyword',
  'dll.code_signature.exists': 'boolean',
  'dll.code_signature.signing_id': 'keyword',
  'dll.code_signature.status': 'keyword',
  'dll.code_signature.subject_name': 'keyword',
  'dll.code_signature.team_id': 'keyword',
  'dll.code_signature.timestamp': 'date',
  'dll.code_signature.trusted': 'boolean',
  'dll.code_signature.valid': 'boolean',
  'dll.hash.md5': 'keyword',
  'dll.hash.sha1': 'keyword',
  'dll.hash.sha256': 'keyword',
  'dll.hash.sha384': 'keyword',
  'dll.hash.sha512': 'keyword',
  'dll.hash.ssdeep': 'keyword',
  'dll.hash.tlsh': 'keyword',
  'dll.name': 'keyword',
  'dll.path': 'keyword',
  'dll.pe.architecture': 'keyword',
  'dll.pe.company': 'keyword',
  'dll.pe.description': 'keyword',
  'dll.pe.file_version': 'keyword',
  'dll.pe.go_import_hash': 'keyword',
  'dll.pe.go_imports': 'flattened',
  'dll.pe.go_imports_names_entropy': 'long',
  'dll.pe.go_imports_names_var_entropy': 'long',
  'dll.pe.go_stripped': 'boolean',
  'dll.pe.imphash': 'keyword',
  'dll.pe.import_hash': 'keyword',
  'dll.pe.imports': 'flattened',
  'dll.pe.imports_names_entropy': 'long',
  'dll.pe.imports_names_var_entropy': 'long',
  'dll.pe.original_file_name': 'keyword',
  'dll.pe.pehash': 'keyword',
  'dll.pe.product': 'keyword',
  'dll.pe.sections': 'nested',
  'dll.pe.sections.entropy': 'long',
  'dll.pe.sections.name': 'keyword',
  'dll.pe.sections.physical_size': 'long',
  'dll.pe.sections.var_entropy': 'long',
  'dll.pe.sections.virtual_size': 'long',
  'dns.answers': 'object',
  'dns.answers.class': 'keyword',
  'dns.answers.data': 'keyword',
  'dns.answers.name': 'keyword',
  'dns.answers.ttl': 'long',
  'dns.answers.type': 'keyword',
  'dns.header_flags': 'keyword',
  'dns.id': 'keyword',
  'dns.op_code': 'keyword',
  'dns.question.class': 'keyword',
  'dns.question.name': 'keyword',
  'dns.question.registered_domain': 'keyword',
  'dns.question.subdomain': 'keyword',
  'dns.question.top_level_domain': 'keyword',
  'dns.question.type': 'keyword',
  'dns.resolved_ip': 'ip',
  'dns.response_code': 'keyword',
  'dns.type': 'keyword',
  'ecs.version': 'keyword',
  'email.attachments': 'nested',
  'email.attachments.file.extension': 'keyword',
  'email.attachments.file.hash.md5': 'keyword',
  'email.attachments.file.hash.sha1': 'keyword',
  'email.attachments.file.hash.sha256': 'keyword',
  'email.attachments.file.hash.sha384': 'keyword',
  'email.attachments.file.hash.sha512': 'keyword',
  'email.attachments.file.hash.ssdeep': 'keyword',
  'email.attachments.file.hash.tlsh': 'keyword',
  'email.attachments.file.mime_type': 'keyword',
  'email.attachments.file.name': 'keyword',
  'email.attachments.file.size': 'long',
  'email.bcc.address': 'keyword',
  'email.cc.address': 'keyword',
  'email.content_type': 'keyword',
  'email.delivery_timestamp': 'date',
  'email.direction': 'keyword',
  'email.from.address': 'keyword',
  'email.local_id': 'keyword',
  'email.message_id': 'wildcard',
  'email.origination_timestamp': 'date',
  'email.reply_to.address': 'keyword',
  'email.sender.address': 'keyword',
  'email.subject': 'keyword',
  'email.to.address': 'keyword',
  'email.x_mailer': 'keyword',
  'error.code': 'keyword',
  'error.id': 'keyword',
  'error.message': 'match_only_text',
  'error.stack_trace': 'wildcard',
  'error.type': 'keyword',
  'event.action': 'keyword',
  'event.agent_id_status': 'keyword',
  'event.category': 'keyword',
  'event.code': 'keyword',
  'event.created': 'date',
  'event.duration': 'long',
  'event.end': 'date',
  'event.hash': 'keyword',
  'event.id': 'keyword',
  'event.ingested': 'date',
  'event.kind': 'keyword',
  'event.original': 'keyword',
  'event.outcome': 'keyword',
  'event.provider': 'keyword',
  'event.reason': 'keyword',
  'event.reference': 'keyword',
  'event.risk_score': 'float',
  'event.risk_score_norm': 'float',
  'event.sequence': 'long',
  'event.severity': 'long',
  'event.start': 'date',
  'event.timezone': 'keyword',
  'event.type': 'keyword',
  'event.url': 'keyword',
  'faas.coldstart': 'boolean',
  'faas.execution': 'keyword',
  'faas.id': 'keyword',
  'faas.name': 'keyword',
  'faas.trigger.request_id': 'keyword',
  'faas.trigger.type': 'keyword',
  'faas.version': 'keyword',
  'file.accessed': 'date',
  'file.attributes': 'keyword',
  'file.code_signature.digest_algorithm': 'keyword',
  'file.code_signature.exists': 'boolean',
  'file.code_signature.signing_id': 'keyword',
  'file.code_signature.status': 'keyword',
  'file.code_signature.subject_name': 'keyword',
  'file.code_signature.team_id': 'keyword',
  'file.code_signature.timestamp': 'date',
  'file.code_signature.trusted': 'boolean',
  'file.code_signature.valid': 'boolean',
  'file.created': 'date',
  'file.ctime': 'date',
  'file.device': 'keyword',
  'file.directory': 'keyword',
  'file.drive_letter': 'keyword',
  'file.elf.architecture': 'keyword',
  'file.elf.byte_order': 'keyword',
  'file.elf.cpu_type': 'keyword',
  'file.elf.creation_date': 'date',
  'file.elf.exports': 'flattened',
  'file.elf.go_import_hash': 'keyword',
  'file.elf.go_imports': 'flattened',
  'file.elf.go_imports_names_entropy': 'long',
  'file.elf.go_imports_names_var_entropy': 'long',
  'file.elf.go_stripped': 'boolean',
  'file.elf.header.abi_version': 'keyword',
  'file.elf.header.class': 'keyword',
  'file.elf.header.data': 'keyword',
  'file.elf.header.entrypoint': 'long',
  'file.elf.header.object_version': 'keyword',
  'file.elf.header.os_abi': 'keyword',
  'file.elf.header.type': 'keyword',
  'file.elf.header.version': 'keyword',
  'file.elf.import_hash': 'keyword',
  'file.elf.imports': 'flattened',
  'file.elf.imports_names_entropy': 'long',
  'file.elf.imports_names_var_entropy': 'long',
  'file.elf.sections': 'nested',
  'file.elf.sections.chi2': 'long',
  'file.elf.sections.entropy': 'long',
  'file.elf.sections.flags': 'keyword',
  'file.elf.sections.name': 'keyword',
  'file.elf.sections.physical_offset': 'keyword',
  'file.elf.sections.physical_size': 'long',
  'file.elf.sections.type': 'keyword',
  'file.elf.sections.var_entropy': 'long',
  'file.elf.sections.virtual_address': 'long',
  'file.elf.sections.virtual_size': 'long',
  'file.elf.segments': 'nested',
  'file.elf.segments.sections': 'keyword',
  'file.elf.segments.type': 'keyword',
  'file.elf.shared_libraries': 'keyword',
  'file.elf.telfhash': 'keyword',
  'file.extension': 'keyword',
  'file.fork_name': 'keyword',
  'file.gid': 'keyword',
  'file.group': 'keyword',
  'file.hash.md5': 'keyword',
  'file.hash.sha1': 'keyword',
  'file.hash.sha256': 'keyword',
  'file.hash.sha384': 'keyword',
  'file.hash.sha512': 'keyword',
  'file.hash.ssdeep': 'keyword',
  'file.hash.tlsh': 'keyword',
  'file.inode': 'keyword',
  'file.macho.go_import_hash': 'keyword',
  'file.macho.go_imports': 'flattened',
  'file.macho.go_imports_names_entropy': 'long',
  'file.macho.go_imports_names_var_entropy': 'long',
  'file.macho.go_stripped': 'boolean',
  'file.macho.import_hash': 'keyword',
  'file.macho.imports': 'flattened',
  'file.macho.imports_names_entropy': 'long',
  'file.macho.imports_names_var_entropy': 'long',
  'file.macho.sections': 'nested',
  'file.macho.sections.entropy': 'long',
  'file.macho.sections.name': 'keyword',
  'file.macho.sections.physical_size': 'long',
  'file.macho.sections.var_entropy': 'long',
  'file.macho.sections.virtual_size': 'long',
  'file.macho.symhash': 'keyword',
  'file.mime_type': 'keyword',
  'file.mode': 'keyword',
  'file.mtime': 'date',
  'file.name': 'keyword',
  'file.owner': 'keyword',
  'file.path': 'keyword',
  'file.pe.architecture': 'keyword',
  'file.pe.company': 'keyword',
  'file.pe.description': 'keyword',
  'file.pe.file_version': 'keyword',
  'file.pe.go_import_hash': 'keyword',
  'file.pe.go_imports': 'flattened',
  'file.pe.go_imports_names_entropy': 'long',
  'file.pe.go_imports_names_var_entropy': 'long',
  'file.pe.go_stripped': 'boolean',
  'file.pe.imphash': 'keyword',
  'file.pe.import_hash': 'keyword',
  'file.pe.imports': 'flattened',
  'file.pe.imports_names_entropy': 'long',
  'file.pe.imports_names_var_entropy': 'long',
  'file.pe.original_file_name': 'keyword',
  'file.pe.pehash': 'keyword',
  'file.pe.product': 'keyword',
  'file.pe.sections': 'nested',
  'file.pe.sections.entropy': 'long',
  'file.pe.sections.name': 'keyword',
  'file.pe.sections.physical_size': 'long',
  'file.pe.sections.var_entropy': 'long',
  'file.pe.sections.virtual_size': 'long',
  'file.size': 'long',
  'file.target_path': 'keyword',
  'file.type': 'keyword',
  'file.uid': 'keyword',
  'file.x509.alternative_names': 'keyword',
  'file.x509.issuer.common_name': 'keyword',
  'file.x509.issuer.country': 'keyword',
  'file.x509.issuer.distinguished_name': 'keyword',
  'file.x509.issuer.locality': 'keyword',
  'file.x509.issuer.organization': 'keyword',
  'file.x509.issuer.organizational_unit': 'keyword',
  'file.x509.issuer.state_or_province': 'keyword',
  'file.x509.not_after': 'date',
  'file.x509.not_before': 'date',
  'file.x509.public_key_algorithm': 'keyword',
  'file.x509.public_key_curve': 'keyword',
  'file.x509.public_key_exponent': 'long',
  'file.x509.public_key_size': 'long',
  'file.x509.serial_number': 'keyword',
  'file.x509.signature_algorithm': 'keyword',
  'file.x509.subject.common_name': 'keyword',
  'file.x509.subject.country': 'keyword',
  'file.x509.subject.distinguished_name': 'keyword',
  'file.x509.subject.locality': 'keyword',
  'file.x509.subject.organization': 'keyword',
  'file.x509.subject.organizational_unit': 'keyword',
  'file.x509.subject.state_or_province': 'keyword',
  'file.x509.version_number': 'keyword',
  'group.domain': 'keyword',
  'group.id': 'keyword',
  'group.name': 'keyword',
  'host.architecture': 'keyword',
  'host.boot.id': 'keyword',
  'host.cpu.usage': 'scaled_float',
  'host.disk.read.bytes': 'long',
  'host.disk.write.bytes': 'long',
  'host.domain': 'keyword',
  'host.geo.city_name': 'keyword',
  'host.geo.continent_code': 'keyword',
  'host.geo.continent_name': 'keyword',
  'host.geo.country_iso_code': 'keyword',
  'host.geo.country_name': 'keyword',
  'host.geo.location': 'geo_point',
  'host.geo.name': 'keyword',
  'host.geo.postal_code': 'keyword',
  'host.geo.region_iso_code': 'keyword',
  'host.geo.region_name': 'keyword',
  'host.geo.timezone': 'keyword',
  'host.hostname': 'keyword',
  'host.id': 'keyword',
  'host.ip': 'ip',
  'host.mac': 'keyword',
  'host.name': 'keyword',
  'host.network.egress.bytes': 'long',
  'host.network.egress.packets': 'long',
  'host.network.ingress.bytes': 'long',
  'host.network.ingress.packets': 'long',
  'host.os.family': 'keyword',
  'host.os.full': 'keyword',
  'host.os.kernel': 'keyword',
  'host.os.name': 'keyword',
  'host.os.platform': 'keyword',
  'host.os.type': 'keyword',
  'host.os.version': 'keyword',
  'host.pid_ns_ino': 'keyword',
  'host.risk.calculated_level': 'keyword',
  'host.risk.calculated_score': 'float',
  'host.risk.calculated_score_norm': 'float',
  'host.risk.static_level': 'keyword',
  'host.risk.static_score': 'float',
  'host.risk.static_score_norm': 'float',
  'host.type': 'keyword',
  'host.uptime': 'long',
  'http.request.body.bytes': 'long',
  'http.request.body.content': 'wildcard',
  'http.request.bytes': 'long',
  'http.request.id': 'keyword',
  'http.request.method': 'keyword',
  'http.request.mime_type': 'keyword',
  'http.request.referrer': 'keyword',
  'http.response.body.bytes': 'long',
  'http.response.body.content': 'wildcard',
  'http.response.bytes': 'long',
  'http.response.mime_type': 'keyword',
  'http.response.status_code': 'long',
  'http.version': 'keyword',
  labels: 'object',
  'log.file.path': 'keyword',
  'log.level': 'keyword',
  'log.logger': 'keyword',
  'log.origin.file.line': 'long',
  'log.origin.file.name': 'keyword',
  'log.origin.function': 'keyword',
  'log.syslog': 'object',
  'log.syslog.appname': 'keyword',
  'log.syslog.facility.code': 'long',
  'log.syslog.facility.name': 'keyword',
  'log.syslog.hostname': 'keyword',
  'log.syslog.msgid': 'keyword',
  'log.syslog.priority': 'long',
  'log.syslog.procid': 'keyword',
  'log.syslog.severity.code': 'long',
  'log.syslog.severity.name': 'keyword',
  'log.syslog.structured_data': 'flattened',
  'log.syslog.version': 'keyword',
  message: 'match_only_text',
  'network.application': 'keyword',
  'network.bytes': 'long',
  'network.community_id': 'keyword',
  'network.direction': 'keyword',
  'network.forwarded_ip': 'ip',
  'network.iana_number': 'keyword',
  'network.inner': 'object',
  'network.inner.vlan.id': 'keyword',
  'network.inner.vlan.name': 'keyword',
  'network.name': 'keyword',
  'network.packets': 'long',
  'network.protocol': 'keyword',
  'network.transport': 'keyword',
  'network.type': 'keyword',
  'network.vlan.id': 'keyword',
  'network.vlan.name': 'keyword',
  'observer.egress': 'object',
  'observer.egress.interface.alias': 'keyword',
  'observer.egress.interface.id': 'keyword',
  'observer.egress.interface.name': 'keyword',
  'observer.egress.vlan.id': 'keyword',
  'observer.egress.vlan.name': 'keyword',
  'observer.egress.zone': 'keyword',
  'observer.geo.city_name': 'keyword',
  'observer.geo.continent_code': 'keyword',
  'observer.geo.continent_name': 'keyword',
  'observer.geo.country_iso_code': 'keyword',
  'observer.geo.country_name': 'keyword',
  'observer.geo.location': 'geo_point',
  'observer.geo.name': 'keyword',
  'observer.geo.postal_code': 'keyword',
  'observer.geo.region_iso_code': 'keyword',
  'observer.geo.region_name': 'keyword',
  'observer.geo.timezone': 'keyword',
  'observer.hostname': 'keyword',
  'observer.ingress': 'object',
  'observer.ingress.interface.alias': 'keyword',
  'observer.ingress.interface.id': 'keyword',
  'observer.ingress.interface.name': 'keyword',
  'observer.ingress.vlan.id': 'keyword',
  'observer.ingress.vlan.name': 'keyword',
  'observer.ingress.zone': 'keyword',
  'observer.ip': 'ip',
  'observer.mac': 'keyword',
  'observer.name': 'keyword',
  'observer.os.family': 'keyword',
  'observer.os.full': 'keyword',
  'observer.os.kernel': 'keyword',
  'observer.os.name': 'keyword',
  'observer.os.platform': 'keyword',
  'observer.os.type': 'keyword',
  'observer.os.version': 'keyword',
  'observer.product': 'keyword',
  'observer.serial_number': 'keyword',
  'observer.type': 'keyword',
  'observer.vendor': 'keyword',
  'observer.version': 'keyword',
  'orchestrator.api_version': 'keyword',
  'orchestrator.cluster.id': 'keyword',
  'orchestrator.cluster.name': 'keyword',
  'orchestrator.cluster.url': 'keyword',
  'orchestrator.cluster.version': 'keyword',
  'orchestrator.namespace': 'keyword',
  'orchestrator.organization': 'keyword',
  'orchestrator.resource.annotation': 'keyword',
  'orchestrator.resource.id': 'keyword',
  'orchestrator.resource.ip': 'ip',
  'orchestrator.resource.label': 'keyword',
  'orchestrator.resource.name': 'keyword',
  'orchestrator.resource.parent.type': 'keyword',
  'orchestrator.resource.type': 'keyword',
  'orchestrator.type': 'keyword',
  'organization.id': 'keyword',
  'organization.name': 'keyword',
  'package.architecture': 'keyword',
  'package.build_version': 'keyword',
  'package.checksum': 'keyword',
  'package.description': 'keyword',
  'package.install_scope': 'keyword',
  'package.installed': 'date',
  'package.license': 'keyword',
  'package.name': 'keyword',
  'package.path': 'keyword',
  'package.reference': 'keyword',
  'package.size': 'long',
  'package.type': 'keyword',
  'package.version': 'keyword',
  'process.args': 'keyword',
  'process.args_count': 'long',
  'process.code_signature.digest_algorithm': 'keyword',
  'process.code_signature.exists': 'boolean',
  'process.code_signature.signing_id': 'keyword',
  'process.code_signature.status': 'keyword',
  'process.code_signature.subject_name': 'keyword',
  'process.code_signature.team_id': 'keyword',
  'process.code_signature.timestamp': 'date',
  'process.code_signature.trusted': 'boolean',
  'process.code_signature.valid': 'boolean',
  'process.command_line': 'wildcard',
  'process.elf.architecture': 'keyword',
  'process.elf.byte_order': 'keyword',
  'process.elf.cpu_type': 'keyword',
  'process.elf.creation_date': 'date',
  'process.elf.exports': 'flattened',
  'process.elf.go_import_hash': 'keyword',
  'process.elf.go_imports': 'flattened',
  'process.elf.go_imports_names_entropy': 'long',
  'process.elf.go_imports_names_var_entropy': 'long',
  'process.elf.go_stripped': 'boolean',
  'process.elf.header.abi_version': 'keyword',
  'process.elf.header.class': 'keyword',
  'process.elf.header.data': 'keyword',
  'process.elf.header.entrypoint': 'long',
  'process.elf.header.object_version': 'keyword',
  'process.elf.header.os_abi': 'keyword',
  'process.elf.header.type': 'keyword',
  'process.elf.header.version': 'keyword',
  'process.elf.import_hash': 'keyword',
  'process.elf.imports': 'flattened',
  'process.elf.imports_names_entropy': 'long',
  'process.elf.imports_names_var_entropy': 'long',
  'process.elf.sections': 'nested',
  'process.elf.sections.chi2': 'long',
  'process.elf.sections.entropy': 'long',
  'process.elf.sections.flags': 'keyword',
  'process.elf.sections.name': 'keyword',
  'process.elf.sections.physical_offset': 'keyword',
  'process.elf.sections.physical_size': 'long',
  'process.elf.sections.type': 'keyword',
  'process.elf.sections.var_entropy': 'long',
  'process.elf.sections.virtual_address': 'long',
  'process.elf.sections.virtual_size': 'long',
  'process.elf.segments': 'nested',
  'process.elf.segments.sections': 'keyword',
  'process.elf.segments.type': 'keyword',
  'process.elf.shared_libraries': 'keyword',
  'process.elf.telfhash': 'keyword',
  'process.end': 'date',
  'process.entity_id': 'keyword',
  'process.entry_leader.args': 'keyword',
  'process.entry_leader.args_count': 'long',
  'process.entry_leader.attested_groups.name': 'keyword',
  'process.entry_leader.attested_user.id': 'keyword',
  'process.entry_leader.attested_user.name': 'keyword',
  'process.entry_leader.command_line': 'wildcard',
  'process.entry_leader.entity_id': 'keyword',
  'process.entry_leader.entry_meta.source.ip': 'ip',
  'process.entry_leader.entry_meta.type': 'keyword',
  'process.entry_leader.executable': 'keyword',
  'process.entry_leader.group.id': 'keyword',
  'process.entry_leader.group.name': 'keyword',
  'process.entry_leader.interactive': 'boolean',
  'process.entry_leader.name': 'keyword',
  'process.entry_leader.parent.entity_id': 'keyword',
  'process.entry_leader.parent.pid': 'long',
  'process.entry_leader.parent.session_leader.entity_id': 'keyword',
  'process.entry_leader.parent.session_leader.pid': 'long',
  'process.entry_leader.parent.session_leader.start': 'date',
  'process.entry_leader.parent.session_leader.vpid': 'long',
  'process.entry_leader.parent.start': 'date',
  'process.entry_leader.parent.vpid': 'long',
  'process.entry_leader.pid': 'long',
  'process.entry_leader.real_group.id': 'keyword',
  'process.entry_leader.real_group.name': 'keyword',
  'process.entry_leader.real_user.id': 'keyword',
  'process.entry_leader.real_user.name': 'keyword',
  'process.entry_leader.same_as_process': 'boolean',
  'process.entry_leader.saved_group.id': 'keyword',
  'process.entry_leader.saved_group.name': 'keyword',
  'process.entry_leader.saved_user.id': 'keyword',
  'process.entry_leader.saved_user.name': 'keyword',
  'process.entry_leader.start': 'date',
  'process.entry_leader.supplemental_groups.id': 'keyword',
  'process.entry_leader.supplemental_groups.name': 'keyword',
  'process.entry_leader.tty': 'object',
  'process.entry_leader.tty.char_device.major': 'long',
  'process.entry_leader.tty.char_device.minor': 'long',
  'process.entry_leader.user.id': 'keyword',
  'process.entry_leader.user.name': 'keyword',
  'process.entry_leader.vpid': 'long',
  'process.entry_leader.working_directory': 'keyword',
  'process.env_vars': 'keyword',
  'process.executable': 'keyword',
  'process.exit_code': 'long',
  'process.group_leader.args': 'keyword',
  'process.group_leader.args_count': 'long',
  'process.group_leader.command_line': 'wildcard',
  'process.group_leader.entity_id': 'keyword',
  'process.group_leader.executable': 'keyword',
  'process.group_leader.group.id': 'keyword',
  'process.group_leader.group.name': 'keyword',
  'process.group_leader.interactive': 'boolean',
  'process.group_leader.name': 'keyword',
  'process.group_leader.pid': 'long',
  'process.group_leader.real_group.id': 'keyword',
  'process.group_leader.real_group.name': 'keyword',
  'process.group_leader.real_user.id': 'keyword',
  'process.group_leader.real_user.name': 'keyword',
  'process.group_leader.same_as_process': 'boolean',
  'process.group_leader.saved_group.id': 'keyword',
  'process.group_leader.saved_group.name': 'keyword',
  'process.group_leader.saved_user.id': 'keyword',
  'process.group_leader.saved_user.name': 'keyword',
  'process.group_leader.start': 'date',
  'process.group_leader.supplemental_groups.id': 'keyword',
  'process.group_leader.supplemental_groups.name': 'keyword',
  'process.group_leader.tty': 'object',
  'process.group_leader.tty.char_device.major': 'long',
  'process.group_leader.tty.char_device.minor': 'long',
  'process.group_leader.user.id': 'keyword',
  'process.group_leader.user.name': 'keyword',
  'process.group_leader.vpid': 'long',
  'process.group_leader.working_directory': 'keyword',
  'process.hash.md5': 'keyword',
  'process.hash.sha1': 'keyword',
  'process.hash.sha256': 'keyword',
  'process.hash.sha384': 'keyword',
  'process.hash.sha512': 'keyword',
  'process.hash.ssdeep': 'keyword',
  'process.hash.tlsh': 'keyword',
  'process.interactive': 'boolean',
  'process.io': 'object',
  'process.io.bytes_skipped': 'object',
  'process.io.bytes_skipped.length': 'long',
  'process.io.bytes_skipped.offset': 'long',
  'process.io.max_bytes_per_process_exceeded': 'boolean',
  'process.io.text': 'wildcard',
  'process.io.total_bytes_captured': 'long',
  'process.io.total_bytes_skipped': 'long',
  'process.io.type': 'keyword',
  'process.macho.go_import_hash': 'keyword',
  'process.macho.go_imports': 'flattened',
  'process.macho.go_imports_names_entropy': 'long',
  'process.macho.go_imports_names_var_entropy': 'long',
  'process.macho.go_stripped': 'boolean',
  'process.macho.import_hash': 'keyword',
  'process.macho.imports': 'flattened',
  'process.macho.imports_names_entropy': 'long',
  'process.macho.imports_names_var_entropy': 'long',
  'process.macho.sections': 'nested',
  'process.macho.sections.entropy': 'long',
  'process.macho.sections.name': 'keyword',
  'process.macho.sections.physical_size': 'long',
  'process.macho.sections.var_entropy': 'long',
  'process.macho.sections.virtual_size': 'long',
  'process.macho.symhash': 'keyword',
  'process.name': 'keyword',
  'process.parent.args': 'keyword',
  'process.parent.args_count': 'long',
  'process.parent.code_signature.digest_algorithm': 'keyword',
  'process.parent.code_signature.exists': 'boolean',
  'process.parent.code_signature.signing_id': 'keyword',
  'process.parent.code_signature.status': 'keyword',
  'process.parent.code_signature.subject_name': 'keyword',
  'process.parent.code_signature.team_id': 'keyword',
  'process.parent.code_signature.timestamp': 'date',
  'process.parent.code_signature.trusted': 'boolean',
  'process.parent.code_signature.valid': 'boolean',
  'process.parent.command_line': 'wildcard',
  'process.parent.elf.architecture': 'keyword',
  'process.parent.elf.byte_order': 'keyword',
  'process.parent.elf.cpu_type': 'keyword',
  'process.parent.elf.creation_date': 'date',
  'process.parent.elf.exports': 'flattened',
  'process.parent.elf.go_import_hash': 'keyword',
  'process.parent.elf.go_imports': 'flattened',
  'process.parent.elf.go_imports_names_entropy': 'long',
  'process.parent.elf.go_imports_names_var_entropy': 'long',
  'process.parent.elf.go_stripped': 'boolean',
  'process.parent.elf.header.abi_version': 'keyword',
  'process.parent.elf.header.class': 'keyword',
  'process.parent.elf.header.data': 'keyword',
  'process.parent.elf.header.entrypoint': 'long',
  'process.parent.elf.header.object_version': 'keyword',
  'process.parent.elf.header.os_abi': 'keyword',
  'process.parent.elf.header.type': 'keyword',
  'process.parent.elf.header.version': 'keyword',
  'process.parent.elf.import_hash': 'keyword',
  'process.parent.elf.imports': 'flattened',
  'process.parent.elf.imports_names_entropy': 'long',
  'process.parent.elf.imports_names_var_entropy': 'long',
  'process.parent.elf.sections': 'nested',
  'process.parent.elf.sections.chi2': 'long',
  'process.parent.elf.sections.entropy': 'long',
  'process.parent.elf.sections.flags': 'keyword',
  'process.parent.elf.sections.name': 'keyword',
  'process.parent.elf.sections.physical_offset': 'keyword',
  'process.parent.elf.sections.physical_size': 'long',
  'process.parent.elf.sections.type': 'keyword',
  'process.parent.elf.sections.var_entropy': 'long',
  'process.parent.elf.sections.virtual_address': 'long',
  'process.parent.elf.sections.virtual_size': 'long',
  'process.parent.elf.segments': 'nested',
  'process.parent.elf.segments.sections': 'keyword',
  'process.parent.elf.segments.type': 'keyword',
  'process.parent.elf.shared_libraries': 'keyword',
  'process.parent.elf.telfhash': 'keyword',
  'process.parent.end': 'date',
  'process.parent.entity_id': 'keyword',
  'process.parent.executable': 'keyword',
  'process.parent.exit_code': 'long',
  'process.parent.group.id': 'keyword',
  'process.parent.group.name': 'keyword',
  'process.parent.group_leader.entity_id': 'keyword',
  'process.parent.group_leader.pid': 'long',
  'process.parent.group_leader.start': 'date',
  'process.parent.group_leader.vpid': 'long',
  'process.parent.hash.md5': 'keyword',
  'process.parent.hash.sha1': 'keyword',
  'process.parent.hash.sha256': 'keyword',
  'process.parent.hash.sha384': 'keyword',
  'process.parent.hash.sha512': 'keyword',
  'process.parent.hash.ssdeep': 'keyword',
  'process.parent.hash.tlsh': 'keyword',
  'process.parent.interactive': 'boolean',
  'process.parent.macho.go_import_hash': 'keyword',
  'process.parent.macho.go_imports': 'flattened',
  'process.parent.macho.go_imports_names_entropy': 'long',
  'process.parent.macho.go_imports_names_var_entropy': 'long',
  'process.parent.macho.go_stripped': 'boolean',
  'process.parent.macho.import_hash': 'keyword',
  'process.parent.macho.imports': 'flattened',
  'process.parent.macho.imports_names_entropy': 'long',
  'process.parent.macho.imports_names_var_entropy': 'long',
  'process.parent.macho.sections': 'nested',
  'process.parent.macho.sections.entropy': 'long',
  'process.parent.macho.sections.name': 'keyword',
  'process.parent.macho.sections.physical_size': 'long',
  'process.parent.macho.sections.var_entropy': 'long',
  'process.parent.macho.sections.virtual_size': 'long',
  'process.parent.macho.symhash': 'keyword',
  'process.parent.name': 'keyword',
  'process.parent.pe.architecture': 'keyword',
  'process.parent.pe.company': 'keyword',
  'process.parent.pe.description': 'keyword',
  'process.parent.pe.file_version': 'keyword',
  'process.parent.pe.go_import_hash': 'keyword',
  'process.parent.pe.go_imports': 'flattened',
  'process.parent.pe.go_imports_names_entropy': 'long',
  'process.parent.pe.go_imports_names_var_entropy': 'long',
  'process.parent.pe.go_stripped': 'boolean',
  'process.parent.pe.imphash': 'keyword',
  'process.parent.pe.import_hash': 'keyword',
  'process.parent.pe.imports': 'flattened',
  'process.parent.pe.imports_names_entropy': 'long',
  'process.parent.pe.imports_names_var_entropy': 'long',
  'process.parent.pe.original_file_name': 'keyword',
  'process.parent.pe.pehash': 'keyword',
  'process.parent.pe.product': 'keyword',
  'process.parent.pe.sections': 'nested',
  'process.parent.pe.sections.entropy': 'long',
  'process.parent.pe.sections.name': 'keyword',
  'process.parent.pe.sections.physical_size': 'long',
  'process.parent.pe.sections.var_entropy': 'long',
  'process.parent.pe.sections.virtual_size': 'long',
  'process.parent.pgid': 'long',
  'process.parent.pid': 'long',
  'process.parent.real_group.id': 'keyword',
  'process.parent.real_group.name': 'keyword',
  'process.parent.real_user.id': 'keyword',
  'process.parent.real_user.name': 'keyword',
  'process.parent.saved_group.id': 'keyword',
  'process.parent.saved_group.name': 'keyword',
  'process.parent.saved_user.id': 'keyword',
  'process.parent.saved_user.name': 'keyword',
  'process.parent.start': 'date',
  'process.parent.supplemental_groups.id': 'keyword',
  'process.parent.supplemental_groups.name': 'keyword',
  'process.parent.thread.capabilities.effective': 'keyword',
  'process.parent.thread.capabilities.permitted': 'keyword',
  'process.parent.thread.id': 'long',
  'process.parent.thread.name': 'keyword',
  'process.parent.title': 'keyword',
  'process.parent.tty': 'object',
  'process.parent.tty.char_device.major': 'long',
  'process.parent.tty.char_device.minor': 'long',
  'process.parent.uptime': 'long',
  'process.parent.user.id': 'keyword',
  'process.parent.user.name': 'keyword',
  'process.parent.vpid': 'long',
  'process.parent.working_directory': 'keyword',
  'process.pe.architecture': 'keyword',
  'process.pe.company': 'keyword',
  'process.pe.description': 'keyword',
  'process.pe.file_version': 'keyword',
  'process.pe.go_import_hash': 'keyword',
  'process.pe.go_imports': 'flattened',
  'process.pe.go_imports_names_entropy': 'long',
  'process.pe.go_imports_names_var_entropy': 'long',
  'process.pe.go_stripped': 'boolean',
  'process.pe.imphash': 'keyword',
  'process.pe.import_hash': 'keyword',
  'process.pe.imports': 'flattened',
  'process.pe.imports_names_entropy': 'long',
  'process.pe.imports_names_var_entropy': 'long',
  'process.pe.original_file_name': 'keyword',
  'process.pe.pehash': 'keyword',
  'process.pe.product': 'keyword',
  'process.pe.sections': 'nested',
  'process.pe.sections.entropy': 'long',
  'process.pe.sections.name': 'keyword',
  'process.pe.sections.physical_size': 'long',
  'process.pe.sections.var_entropy': 'long',
  'process.pe.sections.virtual_size': 'long',
  'process.pgid': 'long',
  'process.pid': 'long',
  'process.previous.args': 'keyword',
  'process.previous.args_count': 'long',
  'process.previous.executable': 'keyword',
  'process.real_group.id': 'keyword',
  'process.real_group.name': 'keyword',
  'process.real_user.id': 'keyword',
  'process.real_user.name': 'keyword',
  'process.saved_group.id': 'keyword',
  'process.saved_group.name': 'keyword',
  'process.saved_user.id': 'keyword',
  'process.saved_user.name': 'keyword',
  'process.session_leader.args': 'keyword',
  'process.session_leader.args_count': 'long',
  'process.session_leader.command_line': 'wildcard',
  'process.session_leader.entity_id': 'keyword',
  'process.session_leader.executable': 'keyword',
  'process.session_leader.group.id': 'keyword',
  'process.session_leader.group.name': 'keyword',
  'process.session_leader.interactive': 'boolean',
  'process.session_leader.name': 'keyword',
  'process.session_leader.parent.entity_id': 'keyword',
  'process.session_leader.parent.pid': 'long',
  'process.session_leader.parent.session_leader.entity_id': 'keyword',
  'process.session_leader.parent.session_leader.pid': 'long',
  'process.session_leader.parent.session_leader.start': 'date',
  'process.session_leader.parent.session_leader.vpid': 'long',
  'process.session_leader.parent.start': 'date',
  'process.session_leader.parent.vpid': 'long',
  'process.session_leader.pid': 'long',
  'process.session_leader.real_group.id': 'keyword',
  'process.session_leader.real_group.name': 'keyword',
  'process.session_leader.real_user.id': 'keyword',
  'process.session_leader.real_user.name': 'keyword',
  'process.session_leader.same_as_process': 'boolean',
  'process.session_leader.saved_group.id': 'keyword',
  'process.session_leader.saved_group.name': 'keyword',
  'process.session_leader.saved_user.id': 'keyword',
  'process.session_leader.saved_user.name': 'keyword',
  'process.session_leader.start': 'date',
  'process.session_leader.supplemental_groups.id': 'keyword',
  'process.session_leader.supplemental_groups.name': 'keyword',
  'process.session_leader.tty': 'object',
  'process.session_leader.tty.char_device.major': 'long',
  'process.session_leader.tty.char_device.minor': 'long',
  'process.session_leader.user.id': 'keyword',
  'process.session_leader.user.name': 'keyword',
  'process.session_leader.vpid': 'long',
  'process.session_leader.working_directory': 'keyword',
  'process.start': 'date',
  'process.supplemental_groups.id': 'keyword',
  'process.supplemental_groups.name': 'keyword',
  'process.thread.capabilities.effective': 'keyword',
  'process.thread.capabilities.permitted': 'keyword',
  'process.thread.id': 'long',
  'process.thread.name': 'keyword',
  'process.title': 'keyword',
  'process.tty': 'object',
  'process.tty.char_device.major': 'long',
  'process.tty.char_device.minor': 'long',
  'process.tty.columns': 'long',
  'process.tty.rows': 'long',
  'process.uptime': 'long',
  'process.user.id': 'keyword',
  'process.user.name': 'keyword',
  'process.vpid': 'long',
  'process.working_directory': 'keyword',
  'registry.data.bytes': 'keyword',
  'registry.data.strings': 'wildcard',
  'registry.data.type': 'keyword',
  'registry.hive': 'keyword',
  'registry.key': 'keyword',
  'registry.path': 'keyword',
  'registry.value': 'keyword',
  'related.hash': 'keyword',
  'related.hosts': 'keyword',
  'related.ip': 'ip',
  'related.user': 'keyword',
  'rule.author': 'keyword',
  'rule.category': 'keyword',
  'rule.description': 'keyword',
  'rule.id': 'keyword',
  'rule.license': 'keyword',
  'rule.name': 'keyword',
  'rule.reference': 'keyword',
  'rule.ruleset': 'keyword',
  'rule.uuid': 'keyword',
  'rule.version': 'keyword',
  'server.address': 'keyword',
  'server.as.number': 'long',
  'server.as.organization.name': 'keyword',
  'server.bytes': 'long',
  'server.domain': 'keyword',
  'server.geo.city_name': 'keyword',
  'server.geo.continent_code': 'keyword',
  'server.geo.continent_name': 'keyword',
  'server.geo.country_iso_code': 'keyword',
  'server.geo.country_name': 'keyword',
  'server.geo.location': 'geo_point',
  'server.geo.name': 'keyword',
  'server.geo.postal_code': 'keyword',
  'server.geo.region_iso_code': 'keyword',
  'server.geo.region_name': 'keyword',
  'server.geo.timezone': 'keyword',
  'server.ip': 'ip',
  'server.mac': 'keyword',
  'server.nat.ip': 'ip',
  'server.nat.port': 'long',
  'server.packets': 'long',
  'server.port': 'long',
  'server.registered_domain': 'keyword',
  'server.subdomain': 'keyword',
  'server.top_level_domain': 'keyword',
  'server.user.domain': 'keyword',
  'server.user.email': 'keyword',
  'server.user.full_name': 'keyword',
  'server.user.group.domain': 'keyword',
  'server.user.group.id': 'keyword',
  'server.user.group.name': 'keyword',
  'server.user.hash': 'keyword',
  'server.user.id': 'keyword',
  'server.user.name': 'keyword',
  'server.user.roles': 'keyword',
  'service.address': 'keyword',
  'service.environment': 'keyword',
  'service.ephemeral_id': 'keyword',
  'service.id': 'keyword',
  'service.name': 'keyword',
  'service.node.name': 'keyword',
  'service.node.role': 'keyword',
  'service.node.roles': 'keyword',
  'service.origin.address': 'keyword',
  'service.origin.environment': 'keyword',
  'service.origin.ephemeral_id': 'keyword',
  'service.origin.id': 'keyword',
  'service.origin.name': 'keyword',
  'service.origin.node.name': 'keyword',
  'service.origin.node.role': 'keyword',
  'service.origin.node.roles': 'keyword',
  'service.origin.state': 'keyword',
  'service.origin.type': 'keyword',
  'service.origin.version': 'keyword',
  'service.state': 'keyword',
  'service.target.address': 'keyword',
  'service.target.environment': 'keyword',
  'service.target.ephemeral_id': 'keyword',
  'service.target.id': 'keyword',
  'service.target.name': 'keyword',
  'service.target.node.name': 'keyword',
  'service.target.node.role': 'keyword',
  'service.target.node.roles': 'keyword',
  'service.target.state': 'keyword',
  'service.target.type': 'keyword',
  'service.target.version': 'keyword',
  'service.type': 'keyword',
  'service.version': 'keyword',
  'source.address': 'keyword',
  'source.as.number': 'long',
  'source.as.organization.name': 'keyword',
  'source.bytes': 'long',
  'source.domain': 'keyword',
  'source.geo.city_name': 'keyword',
  'source.geo.continent_code': 'keyword',
  'source.geo.continent_name': 'keyword',
  'source.geo.country_iso_code': 'keyword',
  'source.geo.country_name': 'keyword',
  'source.geo.location': 'geo_point',
  'source.geo.name': 'keyword',
  'source.geo.postal_code': 'keyword',
  'source.geo.region_iso_code': 'keyword',
  'source.geo.region_name': 'keyword',
  'source.geo.timezone': 'keyword',
  'source.ip': 'ip',
  'source.mac': 'keyword',
  'source.nat.ip': 'ip',
  'source.nat.port': 'long',
  'source.packets': 'long',
  'source.port': 'long',
  'source.registered_domain': 'keyword',
  'source.subdomain': 'keyword',
  'source.top_level_domain': 'keyword',
  'source.user.domain': 'keyword',
  'source.user.email': 'keyword',
  'source.user.full_name': 'keyword',
  'source.user.group.domain': 'keyword',
  'source.user.group.id': 'keyword',
  'source.user.group.name': 'keyword',
  'source.user.hash': 'keyword',
  'source.user.id': 'keyword',
  'source.user.name': 'keyword',
  'source.user.roles': 'keyword',
  'span.id': 'keyword',
  tags: 'keyword',
  'threat.enrichments': 'nested',
  'threat.enrichments.indicator': 'object',
  'threat.enrichments.indicator.as.number': 'long',
  'threat.enrichments.indicator.as.organization.name': 'keyword',
  'threat.enrichments.indicator.confidence': 'keyword',
  'threat.enrichments.indicator.description': 'keyword',
  'threat.enrichments.indicator.email.address': 'keyword',
  'threat.enrichments.indicator.file.accessed': 'date',
  'threat.enrichments.indicator.file.attributes': 'keyword',
  'threat.enrichments.indicator.file.code_signature.digest_algorithm': 'keyword',
  'threat.enrichments.indicator.file.code_signature.exists': 'boolean',
  'threat.enrichments.indicator.file.code_signature.signing_id': 'keyword',
  'threat.enrichments.indicator.file.code_signature.status': 'keyword',
  'threat.enrichments.indicator.file.code_signature.subject_name': 'keyword',
  'threat.enrichments.indicator.file.code_signature.team_id': 'keyword',
  'threat.enrichments.indicator.file.code_signature.timestamp': 'date',
  'threat.enrichments.indicator.file.code_signature.trusted': 'boolean',
  'threat.enrichments.indicator.file.code_signature.valid': 'boolean',
  'threat.enrichments.indicator.file.created': 'date',
  'threat.enrichments.indicator.file.ctime': 'date',
  'threat.enrichments.indicator.file.device': 'keyword',
  'threat.enrichments.indicator.file.directory': 'keyword',
  'threat.enrichments.indicator.file.drive_letter': 'keyword',
  'threat.enrichments.indicator.file.elf.architecture': 'keyword',
  'threat.enrichments.indicator.file.elf.byte_order': 'keyword',
  'threat.enrichments.indicator.file.elf.cpu_type': 'keyword',
  'threat.enrichments.indicator.file.elf.creation_date': 'date',
  'threat.enrichments.indicator.file.elf.exports': 'flattened',
  'threat.enrichments.indicator.file.elf.go_import_hash': 'keyword',
  'threat.enrichments.indicator.file.elf.go_imports': 'flattened',
  'threat.enrichments.indicator.file.elf.go_imports_names_entropy': 'long',
  'threat.enrichments.indicator.file.elf.go_imports_names_var_entropy': 'long',
  'threat.enrichments.indicator.file.elf.go_stripped': 'boolean',
  'threat.enrichments.indicator.file.elf.header.abi_version': 'keyword',
  'threat.enrichments.indicator.file.elf.header.class': 'keyword',
  'threat.enrichments.indicator.file.elf.header.data': 'keyword',
  'threat.enrichments.indicator.file.elf.header.entrypoint': 'long',
  'threat.enrichments.indicator.file.elf.header.object_version': 'keyword',
  'threat.enrichments.indicator.file.elf.header.os_abi': 'keyword',
  'threat.enrichments.indicator.file.elf.header.type': 'keyword',
  'threat.enrichments.indicator.file.elf.header.version': 'keyword',
  'threat.enrichments.indicator.file.elf.import_hash': 'keyword',
  'threat.enrichments.indicator.file.elf.imports': 'flattened',
  'threat.enrichments.indicator.file.elf.imports_names_entropy': 'long',
  'threat.enrichments.indicator.file.elf.imports_names_var_entropy': 'long',
  'threat.enrichments.indicator.file.elf.sections': 'nested',
  'threat.enrichments.indicator.file.elf.sections.chi2': 'long',
  'threat.enrichments.indicator.file.elf.sections.entropy': 'long',
  'threat.enrichments.indicator.file.elf.sections.flags': 'keyword',
  'threat.enrichments.indicator.file.elf.sections.name': 'keyword',
  'threat.enrichments.indicator.file.elf.sections.physical_offset': 'keyword',
  'threat.enrichments.indicator.file.elf.sections.physical_size': 'long',
  'threat.enrichments.indicator.file.elf.sections.type': 'keyword',
  'threat.enrichments.indicator.file.elf.sections.var_entropy': 'long',
  'threat.enrichments.indicator.file.elf.sections.virtual_address': 'long',
  'threat.enrichments.indicator.file.elf.sections.virtual_size': 'long',
  'threat.enrichments.indicator.file.elf.segments': 'nested',
  'threat.enrichments.indicator.file.elf.segments.sections': 'keyword',
  'threat.enrichments.indicator.file.elf.segments.type': 'keyword',
  'threat.enrichments.indicator.file.elf.shared_libraries': 'keyword',
  'threat.enrichments.indicator.file.elf.telfhash': 'keyword',
  'threat.enrichments.indicator.file.extension': 'keyword',
  'threat.enrichments.indicator.file.fork_name': 'keyword',
  'threat.enrichments.indicator.file.gid': 'keyword',
  'threat.enrichments.indicator.file.group': 'keyword',
  'threat.enrichments.indicator.file.hash.md5': 'keyword',
  'threat.enrichments.indicator.file.hash.sha1': 'keyword',
  'threat.enrichments.indicator.file.hash.sha256': 'keyword',
  'threat.enrichments.indicator.file.hash.sha384': 'keyword',
  'threat.enrichments.indicator.file.hash.sha512': 'keyword',
  'threat.enrichments.indicator.file.hash.ssdeep': 'keyword',
  'threat.enrichments.indicator.file.hash.tlsh': 'keyword',
  'threat.enrichments.indicator.file.inode': 'keyword',
  'threat.enrichments.indicator.file.mime_type': 'keyword',
  'threat.enrichments.indicator.file.mode': 'keyword',
  'threat.enrichments.indicator.file.mtime': 'date',
  'threat.enrichments.indicator.file.name': 'keyword',
  'threat.enrichments.indicator.file.owner': 'keyword',
  'threat.enrichments.indicator.file.path': 'keyword',
  'threat.enrichments.indicator.file.pe.architecture': 'keyword',
  'threat.enrichments.indicator.file.pe.company': 'keyword',
  'threat.enrichments.indicator.file.pe.description': 'keyword',
  'threat.enrichments.indicator.file.pe.file_version': 'keyword',
  'threat.enrichments.indicator.file.pe.go_import_hash': 'keyword',
  'threat.enrichments.indicator.file.pe.go_imports': 'flattened',
  'threat.enrichments.indicator.file.pe.go_imports_names_entropy': 'long',
  'threat.enrichments.indicator.file.pe.go_imports_names_var_entropy': 'long',
  'threat.enrichments.indicator.file.pe.go_stripped': 'boolean',
  'threat.enrichments.indicator.file.pe.imphash': 'keyword',
  'threat.enrichments.indicator.file.pe.import_hash': 'keyword',
  'threat.enrichments.indicator.file.pe.imports': 'flattened',
  'threat.enrichments.indicator.file.pe.imports_names_entropy': 'long',
  'threat.enrichments.indicator.file.pe.imports_names_var_entropy': 'long',
  'threat.enrichments.indicator.file.pe.original_file_name': 'keyword',
  'threat.enrichments.indicator.file.pe.pehash': 'keyword',
  'threat.enrichments.indicator.file.pe.product': 'keyword',
  'threat.enrichments.indicator.file.pe.sections': 'nested',
  'threat.enrichments.indicator.file.pe.sections.entropy': 'long',
  'threat.enrichments.indicator.file.pe.sections.name': 'keyword',
  'threat.enrichments.indicator.file.pe.sections.physical_size': 'long',
  'threat.enrichments.indicator.file.pe.sections.var_entropy': 'long',
  'threat.enrichments.indicator.file.pe.sections.virtual_size': 'long',
  'threat.enrichments.indicator.file.size': 'long',
  'threat.enrichments.indicator.file.target_path': 'keyword',
  'threat.enrichments.indicator.file.type': 'keyword',
  'threat.enrichments.indicator.file.uid': 'keyword',
  'threat.enrichments.indicator.file.x509.alternative_names': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.common_name': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.country': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.distinguished_name': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.locality': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.organization': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.organizational_unit': 'keyword',
  'threat.enrichments.indicator.file.x509.issuer.state_or_province': 'keyword',
  'threat.enrichments.indicator.file.x509.not_after': 'date',
  'threat.enrichments.indicator.file.x509.not_before': 'date',
  'threat.enrichments.indicator.file.x509.public_key_algorithm': 'keyword',
  'threat.enrichments.indicator.file.x509.public_key_curve': 'keyword',
  'threat.enrichments.indicator.file.x509.public_key_exponent': 'long',
  'threat.enrichments.indicator.file.x509.public_key_size': 'long',
  'threat.enrichments.indicator.file.x509.serial_number': 'keyword',
  'threat.enrichments.indicator.file.x509.signature_algorithm': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.common_name': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.country': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.distinguished_name': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.locality': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.organization': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.organizational_unit': 'keyword',
  'threat.enrichments.indicator.file.x509.subject.state_or_province': 'keyword',
  'threat.enrichments.indicator.file.x509.version_number': 'keyword',
  'threat.enrichments.indicator.first_seen': 'date',
  'threat.enrichments.indicator.geo.city_name': 'keyword',
  'threat.enrichments.indicator.geo.continent_code': 'keyword',
  'threat.enrichments.indicator.geo.continent_name': 'keyword',
  'threat.enrichments.indicator.geo.country_iso_code': 'keyword',
  'threat.enrichments.indicator.geo.country_name': 'keyword',
  'threat.enrichments.indicator.geo.location': 'geo_point',
  'threat.enrichments.indicator.geo.name': 'keyword',
  'threat.enrichments.indicator.geo.postal_code': 'keyword',
  'threat.enrichments.indicator.geo.region_iso_code': 'keyword',
  'threat.enrichments.indicator.geo.region_name': 'keyword',
  'threat.enrichments.indicator.geo.timezone': 'keyword',
  'threat.enrichments.indicator.ip': 'ip',
  'threat.enrichments.indicator.last_seen': 'date',
  'threat.enrichments.indicator.marking.tlp': 'keyword',
  'threat.enrichments.indicator.marking.tlp_version': 'keyword',
  'threat.enrichments.indicator.modified_at': 'date',
  'threat.enrichments.indicator.name': 'keyword',
  'threat.enrichments.indicator.port': 'long',
  'threat.enrichments.indicator.provider': 'keyword',
  'threat.enrichments.indicator.reference': 'keyword',
  'threat.enrichments.indicator.registry.data.bytes': 'keyword',
  'threat.enrichments.indicator.registry.data.strings': 'wildcard',
  'threat.enrichments.indicator.registry.data.type': 'keyword',
  'threat.enrichments.indicator.registry.hive': 'keyword',
  'threat.enrichments.indicator.registry.key': 'keyword',
  'threat.enrichments.indicator.registry.path': 'keyword',
  'threat.enrichments.indicator.registry.value': 'keyword',
  'threat.enrichments.indicator.scanner_stats': 'long',
  'threat.enrichments.indicator.sightings': 'long',
  'threat.enrichments.indicator.type': 'keyword',
  'threat.enrichments.indicator.url.domain': 'keyword',
  'threat.enrichments.indicator.url.extension': 'keyword',
  'threat.enrichments.indicator.url.fragment': 'keyword',
  'threat.enrichments.indicator.url.full': 'wildcard',
  'threat.enrichments.indicator.url.original': 'wildcard',
  'threat.enrichments.indicator.url.password': 'keyword',
  'threat.enrichments.indicator.url.path': 'wildcard',
  'threat.enrichments.indicator.url.port': 'long',
  'threat.enrichments.indicator.url.query': 'keyword',
  'threat.enrichments.indicator.url.registered_domain': 'keyword',
  'threat.enrichments.indicator.url.scheme': 'keyword',
  'threat.enrichments.indicator.url.subdomain': 'keyword',
  'threat.enrichments.indicator.url.top_level_domain': 'keyword',
  'threat.enrichments.indicator.url.username': 'keyword',
  'threat.enrichments.indicator.x509.alternative_names': 'keyword',
  'threat.enrichments.indicator.x509.issuer.common_name': 'keyword',
  'threat.enrichments.indicator.x509.issuer.country': 'keyword',
  'threat.enrichments.indicator.x509.issuer.distinguished_name': 'keyword',
  'threat.enrichments.indicator.x509.issuer.locality': 'keyword',
  'threat.enrichments.indicator.x509.issuer.organization': 'keyword',
  'threat.enrichments.indicator.x509.issuer.organizational_unit': 'keyword',
  'threat.enrichments.indicator.x509.issuer.state_or_province': 'keyword',
  'threat.enrichments.indicator.x509.not_after': 'date',
  'threat.enrichments.indicator.x509.not_before': 'date',
  'threat.enrichments.indicator.x509.public_key_algorithm': 'keyword',
  'threat.enrichments.indicator.x509.public_key_curve': 'keyword',
  'threat.enrichments.indicator.x509.public_key_exponent': 'long',
  'threat.enrichments.indicator.x509.public_key_size': 'long',
  'threat.enrichments.indicator.x509.serial_number': 'keyword',
  'threat.enrichments.indicator.x509.signature_algorithm': 'keyword',
  'threat.enrichments.indicator.x509.subject.common_name': 'keyword',
  'threat.enrichments.indicator.x509.subject.country': 'keyword',
  'threat.enrichments.indicator.x509.subject.distinguished_name': 'keyword',
  'threat.enrichments.indicator.x509.subject.locality': 'keyword',
  'threat.enrichments.indicator.x509.subject.organization': 'keyword',
  'threat.enrichments.indicator.x509.subject.organizational_unit': 'keyword',
  'threat.enrichments.indicator.x509.subject.state_or_province': 'keyword',
  'threat.enrichments.indicator.x509.version_number': 'keyword',
  'threat.enrichments.matched.atomic': 'keyword',
  'threat.enrichments.matched.field': 'keyword',
  'threat.enrichments.matched.id': 'keyword',
  'threat.enrichments.matched.index': 'keyword',
  'threat.enrichments.matched.occurred': 'date',
  'threat.enrichments.matched.type': 'keyword',
  'threat.feed.dashboard_id': 'keyword',
  'threat.feed.description': 'keyword',
  'threat.feed.name': 'keyword',
  'threat.feed.reference': 'keyword',
  'threat.framework': 'keyword',
  'threat.group.alias': 'keyword',
  'threat.group.id': 'keyword',
  'threat.group.name': 'keyword',
  'threat.group.reference': 'keyword',
  'threat.indicator.as.number': 'long',
  'threat.indicator.as.organization.name': 'keyword',
  'threat.indicator.confidence': 'keyword',
  'threat.indicator.description': 'keyword',
  'threat.indicator.email.address': 'keyword',
  'threat.indicator.file.accessed': 'date',
  'threat.indicator.file.attributes': 'keyword',
  'threat.indicator.file.code_signature.digest_algorithm': 'keyword',
  'threat.indicator.file.code_signature.exists': 'boolean',
  'threat.indicator.file.code_signature.signing_id': 'keyword',
  'threat.indicator.file.code_signature.status': 'keyword',
  'threat.indicator.file.code_signature.subject_name': 'keyword',
  'threat.indicator.file.code_signature.team_id': 'keyword',
  'threat.indicator.file.code_signature.timestamp': 'date',
  'threat.indicator.file.code_signature.trusted': 'boolean',
  'threat.indicator.file.code_signature.valid': 'boolean',
  'threat.indicator.file.created': 'date',
  'threat.indicator.file.ctime': 'date',
  'threat.indicator.file.device': 'keyword',
  'threat.indicator.file.directory': 'keyword',
  'threat.indicator.file.drive_letter': 'keyword',
  'threat.indicator.file.elf.architecture': 'keyword',
  'threat.indicator.file.elf.byte_order': 'keyword',
  'threat.indicator.file.elf.cpu_type': 'keyword',
  'threat.indicator.file.elf.creation_date': 'date',
  'threat.indicator.file.elf.exports': 'flattened',
  'threat.indicator.file.elf.go_import_hash': 'keyword',
  'threat.indicator.file.elf.go_imports': 'flattened',
  'threat.indicator.file.elf.go_imports_names_entropy': 'long',
  'threat.indicator.file.elf.go_imports_names_var_entropy': 'long',
  'threat.indicator.file.elf.go_stripped': 'boolean',
  'threat.indicator.file.elf.header.abi_version': 'keyword',
  'threat.indicator.file.elf.header.class': 'keyword',
  'threat.indicator.file.elf.header.data': 'keyword',
  'threat.indicator.file.elf.header.entrypoint': 'long',
  'threat.indicator.file.elf.header.object_version': 'keyword',
  'threat.indicator.file.elf.header.os_abi': 'keyword',
  'threat.indicator.file.elf.header.type': 'keyword',
  'threat.indicator.file.elf.header.version': 'keyword',
  'threat.indicator.file.elf.import_hash': 'keyword',
  'threat.indicator.file.elf.imports': 'flattened',
  'threat.indicator.file.elf.imports_names_entropy': 'long',
  'threat.indicator.file.elf.imports_names_var_entropy': 'long',
  'threat.indicator.file.elf.sections': 'nested',
  'threat.indicator.file.elf.sections.chi2': 'long',
  'threat.indicator.file.elf.sections.entropy': 'long',
  'threat.indicator.file.elf.sections.flags': 'keyword',
  'threat.indicator.file.elf.sections.name': 'keyword',
  'threat.indicator.file.elf.sections.physical_offset': 'keyword',
  'threat.indicator.file.elf.sections.physical_size': 'long',
  'threat.indicator.file.elf.sections.type': 'keyword',
  'threat.indicator.file.elf.sections.var_entropy': 'long',
  'threat.indicator.file.elf.sections.virtual_address': 'long',
  'threat.indicator.file.elf.sections.virtual_size': 'long',
  'threat.indicator.file.elf.segments': 'nested',
  'threat.indicator.file.elf.segments.sections': 'keyword',
  'threat.indicator.file.elf.segments.type': 'keyword',
  'threat.indicator.file.elf.shared_libraries': 'keyword',
  'threat.indicator.file.elf.telfhash': 'keyword',
  'threat.indicator.file.extension': 'keyword',
  'threat.indicator.file.fork_name': 'keyword',
  'threat.indicator.file.gid': 'keyword',
  'threat.indicator.file.group': 'keyword',
  'threat.indicator.file.hash.md5': 'keyword',
  'threat.indicator.file.hash.sha1': 'keyword',
  'threat.indicator.file.hash.sha256': 'keyword',
  'threat.indicator.file.hash.sha384': 'keyword',
  'threat.indicator.file.hash.sha512': 'keyword',
  'threat.indicator.file.hash.ssdeep': 'keyword',
  'threat.indicator.file.hash.tlsh': 'keyword',
  'threat.indicator.file.inode': 'keyword',
  'threat.indicator.file.mime_type': 'keyword',
  'threat.indicator.file.mode': 'keyword',
  'threat.indicator.file.mtime': 'date',
  'threat.indicator.file.name': 'keyword',
  'threat.indicator.file.owner': 'keyword',
  'threat.indicator.file.path': 'keyword',
  'threat.indicator.file.pe.architecture': 'keyword',
  'threat.indicator.file.pe.company': 'keyword',
  'threat.indicator.file.pe.description': 'keyword',
  'threat.indicator.file.pe.file_version': 'keyword',
  'threat.indicator.file.pe.go_import_hash': 'keyword',
  'threat.indicator.file.pe.go_imports': 'flattened',
  'threat.indicator.file.pe.go_imports_names_entropy': 'long',
  'threat.indicator.file.pe.go_imports_names_var_entropy': 'long',
  'threat.indicator.file.pe.go_stripped': 'boolean',
  'threat.indicator.file.pe.imphash': 'keyword',
  'threat.indicator.file.pe.import_hash': 'keyword',
  'threat.indicator.file.pe.imports': 'flattened',
  'threat.indicator.file.pe.imports_names_entropy': 'long',
  'threat.indicator.file.pe.imports_names_var_entropy': 'long',
  'threat.indicator.file.pe.original_file_name': 'keyword',
  'threat.indicator.file.pe.pehash': 'keyword',
  'threat.indicator.file.pe.product': 'keyword',
  'threat.indicator.file.pe.sections': 'nested',
  'threat.indicator.file.pe.sections.entropy': 'long',
  'threat.indicator.file.pe.sections.name': 'keyword',
  'threat.indicator.file.pe.sections.physical_size': 'long',
  'threat.indicator.file.pe.sections.var_entropy': 'long',
  'threat.indicator.file.pe.sections.virtual_size': 'long',
  'threat.indicator.file.size': 'long',
  'threat.indicator.file.target_path': 'keyword',
  'threat.indicator.file.type': 'keyword',
  'threat.indicator.file.uid': 'keyword',
  'threat.indicator.file.x509.alternative_names': 'keyword',
  'threat.indicator.file.x509.issuer.common_name': 'keyword',
  'threat.indicator.file.x509.issuer.country': 'keyword',
  'threat.indicator.file.x509.issuer.distinguished_name': 'keyword',
  'threat.indicator.file.x509.issuer.locality': 'keyword',
  'threat.indicator.file.x509.issuer.organization': 'keyword',
  'threat.indicator.file.x509.issuer.organizational_unit': 'keyword',
  'threat.indicator.file.x509.issuer.state_or_province': 'keyword',
  'threat.indicator.file.x509.not_after': 'date',
  'threat.indicator.file.x509.not_before': 'date',
  'threat.indicator.file.x509.public_key_algorithm': 'keyword',
  'threat.indicator.file.x509.public_key_curve': 'keyword',
  'threat.indicator.file.x509.public_key_exponent': 'long',
  'threat.indicator.file.x509.public_key_size': 'long',
  'threat.indicator.file.x509.serial_number': 'keyword',
  'threat.indicator.file.x509.signature_algorithm': 'keyword',
  'threat.indicator.file.x509.subject.common_name': 'keyword',
  'threat.indicator.file.x509.subject.country': 'keyword',
  'threat.indicator.file.x509.subject.distinguished_name': 'keyword',
  'threat.indicator.file.x509.subject.locality': 'keyword',
  'threat.indicator.file.x509.subject.organization': 'keyword',
  'threat.indicator.file.x509.subject.organizational_unit': 'keyword',
  'threat.indicator.file.x509.subject.state_or_province': 'keyword',
  'threat.indicator.file.x509.version_number': 'keyword',
  'threat.indicator.first_seen': 'date',
  'threat.indicator.geo.city_name': 'keyword',
  'threat.indicator.geo.continent_code': 'keyword',
  'threat.indicator.geo.continent_name': 'keyword',
  'threat.indicator.geo.country_iso_code': 'keyword',
  'threat.indicator.geo.country_name': 'keyword',
  'threat.indicator.geo.location': 'geo_point',
  'threat.indicator.geo.name': 'keyword',
  'threat.indicator.geo.postal_code': 'keyword',
  'threat.indicator.geo.region_iso_code': 'keyword',
  'threat.indicator.geo.region_name': 'keyword',
  'threat.indicator.geo.timezone': 'keyword',
  'threat.indicator.ip': 'ip',
  'threat.indicator.last_seen': 'date',
  'threat.indicator.marking.tlp': 'keyword',
  'threat.indicator.marking.tlp_version': 'keyword',
  'threat.indicator.modified_at': 'date',
  'threat.indicator.name': 'keyword',
  'threat.indicator.port': 'long',
  'threat.indicator.provider': 'keyword',
  'threat.indicator.reference': 'keyword',
  'threat.indicator.registry.data.bytes': 'keyword',
  'threat.indicator.registry.data.strings': 'wildcard',
  'threat.indicator.registry.data.type': 'keyword',
  'threat.indicator.registry.hive': 'keyword',
  'threat.indicator.registry.key': 'keyword',
  'threat.indicator.registry.path': 'keyword',
  'threat.indicator.registry.value': 'keyword',
  'threat.indicator.scanner_stats': 'long',
  'threat.indicator.sightings': 'long',
  'threat.indicator.type': 'keyword',
  'threat.indicator.url.domain': 'keyword',
  'threat.indicator.url.extension': 'keyword',
  'threat.indicator.url.fragment': 'keyword',
  'threat.indicator.url.full': 'wildcard',
  'threat.indicator.url.original': 'wildcard',
  'threat.indicator.url.password': 'keyword',
  'threat.indicator.url.path': 'wildcard',
  'threat.indicator.url.port': 'long',
  'threat.indicator.url.query': 'keyword',
  'threat.indicator.url.registered_domain': 'keyword',
  'threat.indicator.url.scheme': 'keyword',
  'threat.indicator.url.subdomain': 'keyword',
  'threat.indicator.url.top_level_domain': 'keyword',
  'threat.indicator.url.username': 'keyword',
  'threat.indicator.x509.alternative_names': 'keyword',
  'threat.indicator.x509.issuer.common_name': 'keyword',
  'threat.indicator.x509.issuer.country': 'keyword',
  'threat.indicator.x509.issuer.distinguished_name': 'keyword',
  'threat.indicator.x509.issuer.locality': 'keyword',
  'threat.indicator.x509.issuer.organization': 'keyword',
  'threat.indicator.x509.issuer.organizational_unit': 'keyword',
  'threat.indicator.x509.issuer.state_or_province': 'keyword',
  'threat.indicator.x509.not_after': 'date',
  'threat.indicator.x509.not_before': 'date',
  'threat.indicator.x509.public_key_algorithm': 'keyword',
  'threat.indicator.x509.public_key_curve': 'keyword',
  'threat.indicator.x509.public_key_exponent': 'long',
  'threat.indicator.x509.public_key_size': 'long',
  'threat.indicator.x509.serial_number': 'keyword',
  'threat.indicator.x509.signature_algorithm': 'keyword',
  'threat.indicator.x509.subject.common_name': 'keyword',
  'threat.indicator.x509.subject.country': 'keyword',
  'threat.indicator.x509.subject.distinguished_name': 'keyword',
  'threat.indicator.x509.subject.locality': 'keyword',
  'threat.indicator.x509.subject.organization': 'keyword',
  'threat.indicator.x509.subject.organizational_unit': 'keyword',
  'threat.indicator.x509.subject.state_or_province': 'keyword',
  'threat.indicator.x509.version_number': 'keyword',
  'threat.software.alias': 'keyword',
  'threat.software.id': 'keyword',
  'threat.software.name': 'keyword',
  'threat.software.platforms': 'keyword',
  'threat.software.reference': 'keyword',
  'threat.software.type': 'keyword',
  'threat.tactic.id': 'keyword',
  'threat.tactic.name': 'keyword',
  'threat.tactic.reference': 'keyword',
  'threat.technique.id': 'keyword',
  'threat.technique.name': 'keyword',
  'threat.technique.reference': 'keyword',
  'threat.technique.subtechnique.id': 'keyword',
  'threat.technique.subtechnique.name': 'keyword',
  'threat.technique.subtechnique.reference': 'keyword',
  'tls.cipher': 'keyword',
  'tls.client.certificate': 'keyword',
  'tls.client.certificate_chain': 'keyword',
  'tls.client.hash.md5': 'keyword',
  'tls.client.hash.sha1': 'keyword',
  'tls.client.hash.sha256': 'keyword',
  'tls.client.issuer': 'keyword',
  'tls.client.ja3': 'keyword',
  'tls.client.not_after': 'date',
  'tls.client.not_before': 'date',
  'tls.client.server_name': 'keyword',
  'tls.client.subject': 'keyword',
  'tls.client.supported_ciphers': 'keyword',
  'tls.client.x509.alternative_names': 'keyword',
  'tls.client.x509.issuer.common_name': 'keyword',
  'tls.client.x509.issuer.country': 'keyword',
  'tls.client.x509.issuer.distinguished_name': 'keyword',
  'tls.client.x509.issuer.locality': 'keyword',
  'tls.client.x509.issuer.organization': 'keyword',
  'tls.client.x509.issuer.organizational_unit': 'keyword',
  'tls.client.x509.issuer.state_or_province': 'keyword',
  'tls.client.x509.not_after': 'date',
  'tls.client.x509.not_before': 'date',
  'tls.client.x509.public_key_algorithm': 'keyword',
  'tls.client.x509.public_key_curve': 'keyword',
  'tls.client.x509.public_key_exponent': 'long',
  'tls.client.x509.public_key_size': 'long',
  'tls.client.x509.serial_number': 'keyword',
  'tls.client.x509.signature_algorithm': 'keyword',
  'tls.client.x509.subject.common_name': 'keyword',
  'tls.client.x509.subject.country': 'keyword',
  'tls.client.x509.subject.distinguished_name': 'keyword',
  'tls.client.x509.subject.locality': 'keyword',
  'tls.client.x509.subject.organization': 'keyword',
  'tls.client.x509.subject.organizational_unit': 'keyword',
  'tls.client.x509.subject.state_or_province': 'keyword',
  'tls.client.x509.version_number': 'keyword',
  'tls.curve': 'keyword',
  'tls.established': 'boolean',
  'tls.next_protocol': 'keyword',
  'tls.resumed': 'boolean',
  'tls.server.certificate': 'keyword',
  'tls.server.certificate_chain': 'keyword',
  'tls.server.hash.md5': 'keyword',
  'tls.server.hash.sha1': 'keyword',
  'tls.server.hash.sha256': 'keyword',
  'tls.server.issuer': 'keyword',
  'tls.server.ja3s': 'keyword',
  'tls.server.not_after': 'date',
  'tls.server.not_before': 'date',
  'tls.server.subject': 'keyword',
  'tls.server.x509.alternative_names': 'keyword',
  'tls.server.x509.issuer.common_name': 'keyword',
  'tls.server.x509.issuer.country': 'keyword',
  'tls.server.x509.issuer.distinguished_name': 'keyword',
  'tls.server.x509.issuer.locality': 'keyword',
  'tls.server.x509.issuer.organization': 'keyword',
  'tls.server.x509.issuer.organizational_unit': 'keyword',
  'tls.server.x509.issuer.state_or_province': 'keyword',
  'tls.server.x509.not_after': 'date',
  'tls.server.x509.not_before': 'date',
  'tls.server.x509.public_key_algorithm': 'keyword',
  'tls.server.x509.public_key_curve': 'keyword',
  'tls.server.x509.public_key_exponent': 'long',
  'tls.server.x509.public_key_size': 'long',
  'tls.server.x509.serial_number': 'keyword',
  'tls.server.x509.signature_algorithm': 'keyword',
  'tls.server.x509.subject.common_name': 'keyword',
  'tls.server.x509.subject.country': 'keyword',
  'tls.server.x509.subject.distinguished_name': 'keyword',
  'tls.server.x509.subject.locality': 'keyword',
  'tls.server.x509.subject.organization': 'keyword',
  'tls.server.x509.subject.organizational_unit': 'keyword',
  'tls.server.x509.subject.state_or_province': 'keyword',
  'tls.server.x509.version_number': 'keyword',
  'tls.version': 'keyword',
  'tls.version_protocol': 'keyword',
  'trace.id': 'keyword',
  'transaction.id': 'keyword',
  'url.domain': 'keyword',
  'url.extension': 'keyword',
  'url.fragment': 'keyword',
  'url.full': 'wildcard',
  'url.original': 'wildcard',
  'url.password': 'keyword',
  'url.path': 'wildcard',
  'url.port': 'long',
  'url.query': 'keyword',
  'url.registered_domain': 'keyword',
  'url.scheme': 'keyword',
  'url.subdomain': 'keyword',
  'url.top_level_domain': 'keyword',
  'url.username': 'keyword',
  'user.changes.domain': 'keyword',
  'user.changes.email': 'keyword',
  'user.changes.full_name': 'keyword',
  'user.changes.group.domain': 'keyword',
  'user.changes.group.id': 'keyword',
  'user.changes.group.name': 'keyword',
  'user.changes.hash': 'keyword',
  'user.changes.id': 'keyword',
  'user.changes.name': 'keyword',
  'user.changes.roles': 'keyword',
  'user.domain': 'keyword',
  'user.effective.domain': 'keyword',
  'user.effective.email': 'keyword',
  'user.effective.full_name': 'keyword',
  'user.effective.group.domain': 'keyword',
  'user.effective.group.id': 'keyword',
  'user.effective.group.name': 'keyword',
  'user.effective.hash': 'keyword',
  'user.effective.id': 'keyword',
  'user.effective.name': 'keyword',
  'user.effective.roles': 'keyword',
  'user.email': 'keyword',
  'user.full_name': 'keyword',
  'user.group.domain': 'keyword',
  'user.group.id': 'keyword',
  'user.group.name': 'keyword',
  'user.hash': 'keyword',
  'user.id': 'keyword',
  'user.name': 'keyword',
  'user.risk.calculated_level': 'keyword',
  'user.risk.calculated_score': 'float',
  'user.risk.calculated_score_norm': 'float',
  'user.risk.static_level': 'keyword',
  'user.risk.static_score': 'float',
  'user.risk.static_score_norm': 'float',
  'user.roles': 'keyword',
  'user.target.domain': 'keyword',
  'user.target.email': 'keyword',
  'user.target.full_name': 'keyword',
  'user.target.group.domain': 'keyword',
  'user.target.group.id': 'keyword',
  'user.target.group.name': 'keyword',
  'user.target.hash': 'keyword',
  'user.target.id': 'keyword',
  'user.target.name': 'keyword',
  'user.target.roles': 'keyword',
  'user_agent.device.name': 'keyword',
  'user_agent.name': 'keyword',
  'user_agent.original': 'keyword',
  'user_agent.os.family': 'keyword',
  'user_agent.os.full': 'keyword',
  'user_agent.os.kernel': 'keyword',
  'user_agent.os.name': 'keyword',
  'user_agent.os.platform': 'keyword',
  'user_agent.os.type': 'keyword',
  'user_agent.os.version': 'keyword',
  'user_agent.version': 'keyword',
  'volume.bus_type': 'keyword',
  'volume.default_access': 'keyword',
  'volume.device_name': 'keyword',
  'volume.device_type': 'keyword',
  'volume.dos_name': 'keyword',
  'volume.file_system_type': 'keyword',
  'volume.mount_name': 'keyword',
  'volume.nt_name': 'keyword',
  'volume.product_id': 'keyword',
  'volume.product_name': 'keyword',
  'volume.removable': 'boolean',
  'volume.serial_number': 'keyword',
  'volume.size': 'long',
  'volume.vendor_id': 'keyword',
  'volume.vendor_name': 'keyword',
  'volume.writable': 'boolean',
  'vulnerability.category': 'keyword',
  'vulnerability.classification': 'keyword',
  'vulnerability.description': 'keyword',
  'vulnerability.enumeration': 'keyword',
  'vulnerability.id': 'keyword',
  'vulnerability.reference': 'keyword',
  'vulnerability.report_id': 'keyword',
  'vulnerability.scanner.vendor': 'keyword',
  'vulnerability.score.base': 'float',
  'vulnerability.score.environmental': 'float',
  'vulnerability.score.temporal': 'float',
  'vulnerability.score.version': 'keyword',
  'vulnerability.severity': 'keyword'
};
const ECS_FIELDS = exports.ECS_FIELDS = {
  'as.number': 'Unique number allocated to the autonomous system.',
  'as.organization.name': 'Organization name of the autonomous system.',
  'client.address': 'Client network address.',
  'client.bytes': 'Bytes sent from the client to the server.',
  'client.domain': 'Client domain.',
  'client.geo.city_name': 'City name of the client.',
  'client.geo.continent_name': 'Name of the continent of the client.',
  'client.geo.country_name': 'Country name of the client.',
  'client.geo.location': 'Longitude and latitude of the client.',
  'client.geo.region_name': 'Region name of the client.',
  'client.ip': 'Client IP address.',
  'client.mac': 'MAC address of the client.',
  'client.nat.ip': 'Translated IP client address.',
  'client.nat.port': 'Translated port of client address.',
  'client.packets': 'Packets sent from the client to the server.',
  'client.port': 'Client port.',
  'client.registered_domain': 'The highest registered client domain, stripped of the subdomain.',
  'client.subdomain': 'Subdomain of the client.',
  'client.top_level_domain': 'Top level domain of the client.',
  'cloud.account.id': 'The cloud account or organization id.',
  'cloud.availability_zone': 'Availability zone in which this host is running.',
  'cloud.instance.id': 'Instance ID of the host machine.',
  'cloud.instance.name': 'Instance name of the host machine.',
  'cloud.machine.type': 'Machine type of the host machine.',
  'cloud.project.id': 'The cloud project id.',
  'cloud.project.name': 'The cloud project name.',
  'cloud.provider': 'Name of the cloud provider.',
  'cloud.region': 'Region in which this host is running.',
  'container.id': 'Unique container id.',
  'container.image.name': 'Name of the image the container is built on.',
  'container.image.tag': 'Container image tag.',
  'container.labels': 'Image labels.',
  'container.name': 'Container name.',
  'container.runtime': 'Runtime managing this container.',
  'destination.address': 'Destination network address.',
  'destination.bytes': 'Bytes sent from the destination to the source.',
  'destination.domain': 'Destination domain.',
  'destination.geo.city_name': 'City name of the destination.',
  'destination.geo.continent_name': 'Name of the continent of the destination.',
  'destination.geo.country_name': 'Country name of the destination.',
  'destination.geo.location': 'Longitude and latitude of the destination.',
  'destination.geo.region_name': 'Region name of the destination.',
  'destination.ip': 'Destination IP address.',
  'destination.mac': 'MAC address of the destination.',
  'destination.nat.ip': 'Translated IP destination address.',
  'destination.nat.port': 'Translated port of destination address.',
  'destination.packets': 'Packets sent from the destination to the source.',
  'destination.port': 'Destination port.',
  'destination.registered_domain': 'The highest registered destination domain, stripped of the subdomain.',
  'destination.subdomain': 'Subdomain of the destination.',
  'destination.top_level_domain': 'Top level domain of the destination.',
  'destination.user.domain': 'Name of the directory the user is a member of.',
  'destination.user.email': 'User email address.',
  'destination.user.full_name': 'Users full name, if available.',
  'destination.user.group.domain': 'Name of the directory the group is a member of.',
  'destination.user.group.id': 'Unique identifier for the group on the system/platform.',
  'destination.user.group.name': 'Name of the group.',
  'destination.user.id': 'Unique identifier of the user.',
  'destination.user.name': 'Short name or login of the user.',
  'dll.code_signature.status': 'Status of the DLL code signature.',
  'dll.code_signature.subject_name': 'Subject name of the DLL code signer.',
  'dll.code_signature.trusted': 'Flag indicating if the DLL code signature is trusted.',
  'dll.code_signature.valid': 'Flag indicating if the DLL code signature is valid.',
  'dll.hash.md5': 'MD5 hash of the DLL.',
  'dll.hash.sha1': 'SHA1 hash of the DLL.',
  'dll.hash.sha256': 'SHA256 hash of the DLL.',
  'dll.name': 'Name of the DLL.',
  'dll.path': 'Full path to the DLL file.',
  'dll.pe.company': 'PE company name of the DLL.',
  'dll.pe.description': 'PE description of the DLL.',
  'dll.pe.file_version': 'PE file version of the DLL.',
  'dll.pe.imphash': 'PE import hash of the DLL.',
  'dll.pe.original_file_name': 'PE original file name of the DLL.',
  'dll.pe.product': 'PE product name of the DLL.',
  'dll.size': 'Size of the DLL in bytes.',
  'dll.type': 'Type of the DLL.',
  'dns.answers': 'DNS answers.',
  'dns.header_flags': 'DNS header flags.',
  'dns.id': 'DNS message ID.',
  'dns.op_code': 'DNS operation code.',
  'dns.question.class': 'DNS question class.',
  'dns.question.name': 'DNS question name.',
  'dns.question.registered_domain': 'The highest registered DNS question domain, stripped of the subdomain.',
  'dns.question.subdomain': 'Subdomain of the DNS question.',
  'dns.question.top_level_domain': 'Top level domain of the DNS question.',
  'dns.question.type': 'DNS question type.',
  'dns.resolved_ip': 'Resolved IP addresses from DNS query.',
  'dns.response_code': 'DNS response code.',
  'dns.type': 'DNS query type.',
  'email.attachments': 'Email attachments.',
  'email.bcc.address': 'Email addresses of BCC recipients.',
  'email.bcc.domain': 'Domain of BCC recipients.',
  'email.bcc.local': 'Local part of the BCC recipients.',
  'email.bcc.registered_domain': 'The highest registered BCC domain, stripped of the subdomain.',
  'email.bcc.subdomain': 'Subdomain of the BCC recipients.',
  'email.bcc.top_level_domain': 'Top level domain of the BCC recipients.',
  'email.cc.address': 'Email addresses of CC recipients.',
  'email.cc.domain': 'Domain of CC recipients.',
  'email.cc.local': 'Local part of the CC recipients.',
  'email.cc.registered_domain': 'The highest registered CC domain, stripped of the subdomain.',
  'email.cc.subdomain': 'Subdomain of the CC recipients.',
  'email.cc.top_level_domain': 'Top level domain of the CC recipients.',
  'email.content_type': 'Content type of the email.',
  'email.delivery_timestamp': 'Time the email was delivered.',
  'email.direction': 'Direction of the email.',
  'email.from.address': 'Email address of the sender.',
  'email.from.domain': 'Domain of the sender.',
  'email.from.local': 'Local part of the sender.',
  'email.from.registered_domain': 'The highest registered sender domain, stripped of the subdomain.',
  'email.from.subdomain': 'Subdomain of the sender.',
  'email.from.top_level_domain': 'Top level domain of the sender.',
  'email.local_id': 'Local identifier of the email.',
  'email.message_id': 'Message ID of the email.',
  'email.origination_timestamp': 'Time the email was originated.',
  'email.reply_to.address': 'Email address of the reply-to.',
  'email.reply_to.domain': 'Domain of the reply-to.',
  'email.reply_to.local': 'Local part of the reply-to.',
  'email.reply_to.registered_domain': 'The highest registered reply-to domain, stripped of the subdomain.',
  'email.reply_to.subdomain': 'Subdomain of the reply-to.',
  'email.reply_to.top_level_domain': 'Top level domain of the reply-to.',
  'email.sender.address': 'Email address of the sender.',
  'email.sender.domain': 'Domain of the sender.',
  'email.sender.local': 'Local part of the sender.',
  'email.sender.registered_domain': 'The highest registered sender domain, stripped of the subdomain.',
  'email.sender.subdomain': 'Subdomain of the sender.',
  'email.sender.top_level_domain': 'Top level domain of the sender.',
  'email.size': 'Size of the email in bytes.',
  'email.subject': 'Subject of the email.',
  'email.to.address': 'Email addresses of recipients.',
  'email.to.domain': 'Domain of recipients.',
  'email.to.local': 'Local part of the recipients.',
  'email.to.registered_domain': 'The highest registered recipient domain, stripped of the subdomain.',
  'email.to.subdomain': 'Subdomain of the recipients.',
  'email.to.top_level_domain': 'Top level domain of the recipients.',
  'error.code': 'Error code describing the error.',
  'error.id': 'Unique identifier for the error.',
  'error.stack_trace': 'Error stack trace.',
  'error.type': 'Error type.',
  'event.action': 'The action captured by the event.',
  'event.code': 'Identification code for this event.',
  'event.duration': 'Duration of the event in nanoseconds.',
  'event.end': 'Date when the event ended.',
  'event.hash': 'Hash of the event.',
  'event.id': 'Unique ID to describe the event.',
  'event.module': 'Name of the module this data is coming from.',
  'event.outcome': 'The outcome of the event.',
  'event.provider': 'Source of the event.',
  'event.reason': 'Reason why this event happened.',
  'event.reference': 'Reference URL describing this event.',
  'event.result': 'The result of the event.',
  'event.risk_score': 'Risk score or priority of the event.',
  'event.risk_score_norm': 'Normalized risk score or priority of the event.',
  'event.sequence': 'Sequence number of the event.',
  'event.severity': 'Numeric severity of the event.',
  'event.start': 'Date when the event started.',
  'event.timezone': 'Timezone in which the event was captured.',
  'faas.coldstart': 'Indicator of a cold start invocation.',
  'faas.execution': 'Execution identifier.',
  'faas.id': 'Function ID.',
  'faas.name': 'Function name.',
  'faas.version': 'Function version.',
  'file.accessed': 'Last time the file was accessed.',
  'file.attributes': 'File attributes.',
  'file.created': 'Date/time when the file was created.',
  'file.ctime': 'Last time the file attributes or metadata changed.',
  'file.device': 'Device that is the source of the file.',
  'file.directory': 'Directory containing the file.',
  'file.drive_letter': 'Drive letter where the file is located.',
  'file.extension': 'File extension.',
  'file.gid': 'GID or group ID of the file.',
  'file.group': 'Group that owns the file.',
  'file.hash.md5': 'MD5 hash of the file.',
  'file.hash.sha1': 'SHA1 hash of the file.',
  'file.hash.sha256': 'SHA256 hash of the file.',
  'file.inode': 'Inode representing the file in the filesystem.',
  'file.mime_type': 'File MIME type.',
  'file.mode': 'File mode.',
  'file.mtime': 'Last time the file content was modified.',
  'file.name': 'File name.',
  'file.owner': 'File owner.',
  'file.path': 'File path.',
  'file.puid': 'PUID or platform user ID of the file.',
  'file.size': 'File size in bytes.',
  'file.target_path': 'Target path for symbolic links.',
  'file.type': 'File type (file, dir, symlink, etc).',
  'file.uid': 'UID or user ID of the file.',
  'group.domain': 'Domain of the group.',
  'group.id': 'Unique identifier for the group on the system/platform.',
  'group.name': 'Name of the group.',
  'host.architecture': 'Operating system architecture.',
  'host.boot.id': 'Unique host boot identifier.',
  'host.cpu.usage': 'Percent CPU usage.',
  'host.disk.read.bytes': 'Total bytes read.',
  'host.disk.write.bytes': 'Total bytes written.',
  'host.geo.city_name': 'City name of the host.',
  'host.geo.continent_name': 'Name of the continent of the host.',
  'host.geo.country_name': 'Country name of the host.',
  'host.geo.location': 'Longitude and latitude of the host.',
  'host.geo.region_name': 'Region name of the host.',
  'host.hostname': 'Hostname of the host.',
  'host.id': 'Unique host id.',
  'host.ip': 'IP address of the host.',
  'host.mac': 'MAC address of the host.',
  'host.name': 'Name of the host.',
  'host.os.build': 'OS build information.',
  'host.os.family': 'OS family (e.g., redhat, debian, freebsd, windows).',
  'host.os.full': 'Operating system name, including the version or code name.',
  'host.os.kernel': 'Operating system kernel version.',
  'host.os.name': 'Operating system name.',
  'host.os.platform': 'Operating system platform (e.g., centos, ubuntu, windows).',
  'host.os.type': 'Operating system type (linux, macos, unix, windows).',
  'host.os.version': 'Operating system version.',
  'http.request.body.bytes': 'Size in bytes of the request body.',
  'http.request.body.content': 'The full HTTP request body.',
  'http.request.headers': 'HTTP request headers.',
  'http.request.method': 'HTTP request method.',
  'http.request.mime_type': 'MIME type of the HTTP request.',
  'http.request.referrer': 'Referrer for this HTTP request.',
  'http.response.body.bytes': 'Size in bytes of the response body.',
  'http.response.body.content': 'The full HTTP response body.',
  'http.response.headers': 'HTTP response headers.',
  'http.response.mime_type': 'MIME type of the HTTP response.',
  'http.response.status_code': 'HTTP response status code.',
  'http.version': 'HTTP version.',
  'interface.alias': 'Interface alias name.',
  'interface.id': 'Unique identifier for the interface.',
  'interface.name': 'Interface name.',
  'interface.type': 'Interface type.',
  'log.file.path': 'Path to the log file.',
  'log.level': 'Log level of the log event.',
  'log.logger': 'Name of the logger.',
  'log.origin.file.line': 'Line number of the file containing the source code which originated the log.',
  'log.origin.file.name': 'Name of the file containing the source code which originated the log.',
  'log.origin.function': 'Name of the function which originated the log.',
  'log.original': 'The original log message before any modification.',
  'log.syslog.facility.code': 'Syslog facility code.',
  'log.syslog.facility.name': 'Syslog facility name.',
  'log.syslog.severity.code': 'Syslog severity code.',
  'log.syslog.severity.name': 'Syslog severity name.',
  'metricset.name': 'Name of the metricset.',
  'network.application': 'Network application.',
  'network.bytes': 'Total bytes transferred in the network event.',
  'network.community_id': 'A hash of source and destination IPs, ports, and protocol.',
  'network.direction': 'Network traffic direction (inbound, outbound).',
  'network.forwarded_ip': 'The field is used to store the original source IP when a proxy or load balancer is in place.',
  'network.iana_number': 'IANA Protocol Number.',
  'network.name': 'Name given by operators to sections of their network.',
  'network.packets': 'Total packets transferred in the network event.',
  'network.protocol': 'L7 Network protocol name.',
  'network.transport': 'L4 Network transport protocol.',
  'network.type': 'Type of the network.',
  'organization.id': 'Unique identifier for the organization.',
  'organization.name': 'Name of the organization.',
  'package.architecture': 'Package architecture.',
  'package.checksum': 'Checksum of the package.',
  'package.description': 'Package description.',
  'package.install_scope': 'Scope of the package installation.',
  'package.license': 'Package license.',
  'package.name': 'Package name.',
  'package.path': 'Package path.',
  'package.reference': 'Package reference.',
  'package.size': 'Package size.',
  'package.version': 'Package version.',
  'process.args': 'Array of process arguments.',
  'process.args_count': 'Length of the process.args array.',
  'process.code_signature.status': 'Status of the process code signature.',
  'process.code_signature.subject_name': 'Subject name of the process code signer.',
  'process.code_signature.trusted': 'Flag indicating if the process code signature is trusted.',
  'process.code_signature.valid': 'Flag indicating if the process code signature is valid.',
  'process.command_line': 'Full command line that started the process.',
  'process.end': 'The time the process ended.',
  'process.executable': 'Absolute path to the process executable.',
  'process.exit_code': 'Exit code of the process.',
  'process.hash.md5': 'MD5 hash of the process executable.',
  'process.hash.sha1': 'SHA1 hash of the process executable.',
  'process.hash.sha256': 'SHA256 hash of the process executable.',
  'process.name': 'Process name.',
  'process.parent.args': 'Array of parent process arguments.',
  'process.parent.args_count': 'Length of the process.args array.',
  'process.parent.code_signature.status': 'Status of the parent process code signature.',
  'process.parent.code_signature.subject_name': 'Subject name of the parent process code signer.',
  'process.parent.code_signature.trusted': 'Flag indicating if the parent process code signature is trusted.',
  'process.parent.code_signature.valid': 'Flag indicating if the parent process code signature is valid.',
  'process.parent.command_line': 'Full command line that started the parent process.',
  'process.parent.end': 'The time the parent process ended.',
  'process.parent.executable': 'Absolute path to the parent process executable.',
  'process.parent.exit_code': 'Exit code of the parent process.',
  'process.parent.group.id': 'Unique identifier for the group on the system/platform.',
  'process.parent.group.name': 'Name of the group.',
  'process.parent.hash.md5': 'MD5 hash of the parent process executable.',
  'process.parent.hash.sha1': 'SHA1 hash of the parent process executable.',
  'process.parent.hash.sha256': 'SHA256 hash of the parent process executable.',
  'process.parent.name': 'Parent process name.',
  'process.parent.pgid': 'Deprecated identifier of the group of processes the process belongs to.',
  'process.parent.pid': 'Parent process ID.',
  'process.parent.start': 'The date/time when the parent process started.',
  'process.parent.working_directory': 'The working directory of the parent process.',
  'process.parent.user.name': 'Short name or login of the user.',
  'process.pgid': 'Deprecated identifier of the group of processes the process belongs to.',
  'process.pid': 'Process ID.',
  'process.start': 'The date/time when the process started.',
  'process.thread.id': 'Thread ID.',
  'process.thread.name': 'Thread name.',
  'process.title': 'Process title.',
  'process.working_directory': 'The working directory of the process.',
  'rule.author': 'Author of the rule.',
  'rule.category': 'Rule category.',
  'rule.description': 'Rule description.',
  'rule.id': 'Unique rule ID.',
  'rule.license': 'Rule license',
  'rule.name': 'Name of the rule.',
  'rule.reference': 'Rule reference URL',
  'rule.version': 'Rule version',
  'rule.ruleset': 'Rule set to which the rule belongs.',
  'rule.uuid': 'Rule UUID.',
  'server.address': 'Server network address.',
  'server.bytes': 'Bytes sent from the server to the client.',
  'server.domain': 'Server domain.',
  'server.geo.city_name': 'City name of the server.',
  'server.geo.continent_name': 'Name of the continent of the server.',
  'server.geo.country_name': 'Country name of the server.',
  'server.geo.location': 'Longitude and latitude of the server.',
  'server.geo.region_name': 'Region name of the server.',
  'server.ip': 'Server IP address.',
  'server.mac': 'MAC address of the server.',
  'server.nat.ip': 'Translated IP server address.',
  'server.nat.port': 'Translated port of server address.',
  'server.packets': 'Packets sent from the server to the client.',
  'server.port': 'Server port.',
  'server.registered_domain': 'The highest registered server domain, stripped of the subdomain.',
  'server.subdomain': 'Subdomain of the server.',
  'server.top_level_domain': 'Top level domain of the server.',
  'source.address': 'Source network address.',
  'source.bytes': 'Bytes sent from the source to the destination.',
  'source.domain': 'Source domain.',
  'source.geo.city_name': 'City name of the source.',
  'source.geo.continent_name': 'Name of the continent of the source.',
  'source.geo.country_name': 'Country name of the source.',
  'source.geo.location': 'Longitude and latitude of the source.',
  'source.geo.region_name': 'Region name of the source.',
  'source.ip': 'Source IP address.',
  'source.mac': 'MAC address of the source.',
  'source.nat.ip': 'Translated IP source address.',
  'source.nat.port': 'Translated port of source address.',
  'source.packets': 'Packets sent from the source to the destination.',
  'source.port': 'Source port.',
  'source.registered_domain': 'The highest registered source domain, stripped of the subdomain.',
  'source.subdomain': 'Subdomain of the source.',
  'source.top_level_domain': 'Top level domain of the source.',
  'source.user.domain': 'Name of the directory the user is a member of.',
  'source.user.email': 'User email address.',
  'source.user.full_name': 'Users full name, if available.',
  'source.user.group.domain': 'Name of the directory the group is a member of.',
  'source.user.group.id': 'Unique identifier for the group on the system/platform.',
  'source.user.group.name': 'Name of the group.',
  'source.user.id': 'Unique identifier of the user.',
  'source.user.name': 'Short name or login of the user.',
  'source.user.roles': 'Array of user roles at the time of the event.',
  'threat.framework': 'Name of the threat framework used.',
  'threat.tactic.id': 'The ID of the tactic.',
  'threat.tactic.name': 'Name of the tactic.',
  'threat.tactic.reference': 'Reference URL of the tactic.',
  'threat.technique.id': 'The ID of the technique.',
  'threat.technique.name': 'Name of the technique.',
  'threat.technique.reference': 'Reference URL of the technique.',
  'threat.technique.subtechnique.id': 'The ID of the subtechnique.',
  'threat.technique.subtechnique.name': 'Name of the subtechnique.',
  'threat.technique.subtechnique.reference': 'Reference URL of the subtechnique.',
  'tls.server.x509.alternative_names': 'List of subject alternative names (SAN).',
  'tls.server.x509.issuer.common_name': 'List of common name (CN) of issuing certificate authority.',
  'trace.id': 'Unique identifier for a trace.',
  'transaction.id': 'Unique identifier for a transaction.',
  'url.domain': 'Domain of the URL.',
  'url.extension': 'File extension from the URL.',
  'url.fragment': 'Fragment identifier of the URL.',
  'url.full': 'Full URL.',
  'url.original': 'Original URL.',
  'url.password': 'Password from the URL.',
  'url.path': 'Path of the URL.',
  'url.port': 'Port of the URL.',
  'url.query': 'Query string of the URL.',
  'url.registered_domain': 'The highest registered domain, stripped of the subdomain.',
  'url.scheme': 'Scheme of the URL.',
  'url.subdomain': 'Subdomain of the URL.',
  'url.top_level_domain': 'Top level domain of the URL.',
  'url.username': 'Username from the URL.',
  'user.changes.domain': 'Domain of the target user.',
  'user.changes.email': "Target user's email address.",
  'user.changes.full_name': "Target user's full name.",
  'user.changes.group.id': "Unique identifier for the target user's group.",
  'user.changes.group.name': "Target user's group name.",
  'user.changes.id': 'Unique identifier of the target user.',
  'user.changes.name': "Target user's name.",
  'user.domain': 'Domain of the user.',
  'user.effective.domain': 'Domain of the effective user.',
  'user.effective.email': "Effective user's email address.",
  'user.effective.full_name': "Effective user's full name.",
  'user.effective.group.id': "Unique identifier for the effective user's group.",
  'user.effective.group.name': "Effective user's group name.",
  'user.effective.id': 'Unique identifier of the effective user.',
  'user.effective.name': "Effective user's name.",
  'user.email': "User's email address.",
  'user.full_name': "User's full name.",
  'user.group.domain': "Domain of the user's group.",
  'user.group.id': "Unique identifier for the user's group.",
  'user.group.name': "User's group name.",
  'user.hash': 'User hash.',
  'user.id': 'Unique identifier of the user.',
  'user.name': "User's name.",
  'user.target.domain': 'Domain of the target user.',
  'user.target.email': "Target user's email address.",
  'user.target.full_name': "Target user's full name.",
  'user.target.group.id': "Unique identifier for the target user's group.",
  'user.target.group.name': "Target user's group name.",
  'user.target.id': 'Unique identifier of the target user.',
  'user.target.name': "Target user's name.",
  'user_agent.device.name': 'Device name from the user agent string.',
  'user_agent.name': 'Name of the user agent.',
  'user_agent.original': 'Original user agent string.',
  'user_agent.os.family': 'OS family from the user agent string.',
  'user_agent.os.full': 'Full OS information from the user agent string.',
  'user_agent.os.name': 'OS name from the user agent string.',
  'user_agent.os.version': 'OS version from the user agent string.',
  'user_agent.version': 'Version of the user agent.',
  'vlan.id': 'VLAN ID.',
  'vlan.name': 'VLAN name.',
  'vulnerability.category': 'Vulnerability category.',
  'vulnerability.classification': 'Vulnerability classification.',
  'vulnerability.description': 'Vulnerability description.',
  'vulnerability.enumeration': 'Vulnerability enumeration.',
  'vulnerability.id': 'Unique vulnerability identifier.',
  'vulnerability.reference': 'Vulnerability reference URL.',
  'vulnerability.report_id': 'The report or scan identification number.',
  'vulnerability.scanner.vendor': 'Name of the vulnerability scanner vendor.',
  'vulnerability.score.base': 'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Base scores cover an assessment for exploitability metrics (attack vector, complexity, privileges, and user interaction), impact metrics (confidentiality, integrity, and availability), and scope..',
  'vulnerability.score.environmental': 'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Environmental scores cover an assessment for any modified Base metrics, confidentiality, integrity, and availability requirements.',
  'vulnerability.score.temporal': 'Scores can range from 0.0 to 10.0, with 10.0 being the most severe. Temporal scores cover an assessment for code maturity, remediation level, and confidence.',
  'vulnerability.score.version': 'The National Vulnerability Database (NVD) provides qualitative severity rankings of "Low", "Medium", and "High" for CVSS v2.0 base score ranges in addition to the severity ratings for CVSS v3.0 as they are defined in the CVSS v3.0 specification.',
  'vulnerability.severity': 'Vulnerability severity.'
};
const ECS_EXAMPLE_ANSWER = exports.ECS_EXAMPLE_ANSWER = {
  crowdstrike: {
    falcon: {
      metadata: {
        customerIDString: null,
        offset: null,
        eventType: {
          target: 'event.code',
          confidence: 0.94,
          type: 'string',
          date_formats: []
        },
        eventCreationTime: {
          target: 'event.created',
          confidence: 0.85,
          type: 'date',
          date_formats: ['UNIX']
        },
        version: null,
        event: {
          DeviceId: null,
          CustomerId: null,
          Ipv: {
            target: 'network.type',
            confidence: 0.99,
            type: 'string',
            date_formats: []
          }
        }
      }
    }
  }
};
const ECS_RESERVED = exports.ECS_RESERVED = ['ecs.version', 'error.message', 'event.category', 'event.created', 'event.dataset', 'event.ingested', 'event.original', 'event.type'];