"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ROUTE_HANDLER_TIMEOUT = exports.LogFormat = exports.LANG_CHAIN_TIMEOUT = exports.CONNECTOR_TIMEOUT = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ROUTE_HANDLER_TIMEOUT = exports.ROUTE_HANDLER_TIMEOUT = 10 * 60 * 1000; // 10 * 60 seconds = 10 minutes
const LANG_CHAIN_TIMEOUT = exports.LANG_CHAIN_TIMEOUT = ROUTE_HANDLER_TIMEOUT - 10_000; // 9 minutes 50 seconds
const CONNECTOR_TIMEOUT = exports.CONNECTOR_TIMEOUT = LANG_CHAIN_TIMEOUT - 10_000; // 9 minutes 40 seconds
let LogFormat = exports.LogFormat = /*#__PURE__*/function (LogFormat) {
  LogFormat["JSON"] = "json";
  LogFormat["NDJSON"] = "ndjson";
  LogFormat["CSV"] = "csv";
  LogFormat["STRUCTURED"] = "structured";
  LogFormat["UNSTRUCTURED"] = "unstructured";
  return LogFormat;
}({});