"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ReviewCelStep = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _step_content_wrapper = require("../step_content_wrapper");
var i18n = _interopRequireWildcard(require("./translations"));
var _cel_config_results = require("./cel_config_results");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ReviewCelStep = exports.ReviewCelStep = /*#__PURE__*/_react.default.memo(({
  isGenerating,
  celInputResult
}) => {
  return /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.TITLE,
    subtitle: i18n.DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    "data-test-subj": "reviewCelStep"
  }, isGenerating ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "l"
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_cel_config_results.CelConfigResults, {
    celInputResult: celInputResult
  }))));
});
ReviewCelStep.displayName = 'ReviewCelStep';