"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CelInputStep = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _step_content_wrapper = require("../step_content_wrapper");
var _state = require("../../state");
var _generation_modal = require("./generation_modal");
var _api_definition_input = require("./api_definition_input");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CelInputStep = exports.CelInputStep = /*#__PURE__*/_react.default.memo(({
  integrationSettings,
  connector,
  isGenerating
}) => {
  const {
    setIsGenerating,
    setStep,
    setCelInputResult
  } = (0, _state.useActions)();
  const onGenerationCompleted = (0, _react.useCallback)(result => {
    if (result) {
      setCelInputResult(result);
      setIsGenerating(false);
      setStep(6);
    }
  }, [setCelInputResult, setIsGenerating, setStep]);
  const onGenerationClosed = (0, _react.useCallback)(() => {
    setIsGenerating(false); // aborts generation
  }, [setIsGenerating]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "l",
    "data-test-subj": "celInputStep"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_step_content_wrapper.StepContentWrapper, {
    title: i18n.CEL_INPUT_TITLE,
    subtitle: i18n.CEL_INPUT_DESCRIPTION
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form",
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_api_definition_input.ApiDefinitionInput, {
    integrationSettings: integrationSettings
  })))), isGenerating && /*#__PURE__*/_react.default.createElement(_generation_modal.GenerationModal, {
    integrationSettings: integrationSettings,
    connector: connector,
    onComplete: onGenerationCompleted,
    onClose: onGenerationClosed
  })));
});
CelInputStep.displayName = 'CelInputStep';