"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RELATED_GRAPH_PATH = exports.PLUGIN_ID = exports.NAME_REGEX_PATTERN = exports.MINIMUM_LICENSE_TYPE = exports.LOG_FORMAT_DETECTION_SAMPLE_ROWS = exports.INTEGRATION_BUILDER_PATH = exports.INTEGRATION_ASSISTANT_BASE_PATH = exports.INTEGRATION_ASSISTANT_APP_ROUTE = exports.GenerationErrorCode = exports.FRONTEND_SAMPLE_ROWS = exports.FLEET_PACKAGES_PATH = exports.ECS_GRAPH_PATH = exports.CHECK_PIPELINE_PATH = exports.CEL_INPUT_GRAPH_PATH = exports.CATEROGIZATION_REVIEW_BATCH_SIZE = exports.CATEGORIZATION_REVIEW_MAX_CYCLES = exports.CATEGORIZATION_RECURSION_LIMIT = exports.CATEGORIZATION_INITIAL_BATCH_SIZE = exports.CATEGORIZATION_GRAPH_PATH = exports.ANALYZE_LOGS_PATH = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Plugin information
const PLUGIN_ID = exports.PLUGIN_ID = 'integrationAssistant';

// Public App Routes
const INTEGRATION_ASSISTANT_APP_ROUTE = exports.INTEGRATION_ASSISTANT_APP_ROUTE = '/app/integration_assistant';

// Server API Routes
const INTEGRATION_ASSISTANT_BASE_PATH = exports.INTEGRATION_ASSISTANT_BASE_PATH = '/api/integration_assistant';
const ECS_GRAPH_PATH = exports.ECS_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/ecs`;
const CATEGORIZATION_GRAPH_PATH = exports.CATEGORIZATION_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/categorization`;
const ANALYZE_LOGS_PATH = exports.ANALYZE_LOGS_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/analyzelogs`;
const RELATED_GRAPH_PATH = exports.RELATED_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/related`;
const CEL_INPUT_GRAPH_PATH = exports.CEL_INPUT_GRAPH_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/cel`;
const CHECK_PIPELINE_PATH = exports.CHECK_PIPELINE_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/pipeline`;
const INTEGRATION_BUILDER_PATH = exports.INTEGRATION_BUILDER_PATH = `${INTEGRATION_ASSISTANT_BASE_PATH}/build`;
const FLEET_PACKAGES_PATH = exports.FLEET_PACKAGES_PATH = `/api/fleet/epm/packages`;

// License
const MINIMUM_LICENSE_TYPE = exports.MINIMUM_LICENSE_TYPE = 'enterprise';

// ErrorCodes
let GenerationErrorCode = exports.GenerationErrorCode = /*#__PURE__*/function (GenerationErrorCode) {
  GenerationErrorCode["RECURSION_LIMIT"] = "recursion-limit";
  GenerationErrorCode["RECURSION_LIMIT_ANALYZE_LOGS"] = "recursion-limit-analyze-logs";
  GenerationErrorCode["UNSUPPORTED_LOG_SAMPLES_FORMAT"] = "unsupported-log-samples-format";
  GenerationErrorCode["UNPARSEABLE_CSV_DATA"] = "unparseable-csv-data";
  GenerationErrorCode["CEF_ERROR"] = "cef-not-supported";
  return GenerationErrorCode;
}({}); // Size limits
const FRONTEND_SAMPLE_ROWS = exports.FRONTEND_SAMPLE_ROWS = 100;
const LOG_FORMAT_DETECTION_SAMPLE_ROWS = exports.LOG_FORMAT_DETECTION_SAMPLE_ROWS = 5;
const CATEGORIZATION_INITIAL_BATCH_SIZE = exports.CATEGORIZATION_INITIAL_BATCH_SIZE = 60;
const CATEROGIZATION_REVIEW_BATCH_SIZE = exports.CATEROGIZATION_REVIEW_BATCH_SIZE = 40;
const CATEGORIZATION_REVIEW_MAX_CYCLES = exports.CATEGORIZATION_REVIEW_MAX_CYCLES = 5;
const CATEGORIZATION_RECURSION_LIMIT = exports.CATEGORIZATION_RECURSION_LIMIT = 50;

// Name regex pattern
const NAME_REGEX_PATTERN = exports.NAME_REGEX_PATTERN = /^[a-z0-9_]+$/;