"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterView = ClusterView;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shards_view = require("./shards_view");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ClusterView({
  clusterDetails
}) {
  var _clusterDetails$failu, _clusterDetails$failu2;
  const clusterFailure = ((_clusterDetails$failu = clusterDetails.failures) !== null && _clusterDetails$failu !== void 0 ? _clusterDetails$failu : []).find(failure => {
    return failure.shard < 0;
  });
  const shardFailures = ((_clusterDetails$failu2 = clusterDetails.failures) !== null && _clusterDetails$failu2 !== void 0 ? _clusterDetails$failu2 : []).filter(failure => {
    return failure.shard >= 0;
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    style: {
      width: '100%'
    },
    size: "xs",
    "data-test-subj": "inspectorRequestClustersDetails"
  }, clusterDetails.timed_out ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('inspector.requests.clusters.timedOutMessage', {
      defaultMessage: 'Request timed out before completion. Results may be incomplete or empty.'
    }),
    iconType: "warning"
  }) : null, clusterFailure ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    color: "warning",
    title: _i18n.i18n.translate('inspector.requests.clusters.failedClusterMessage', {
      defaultMessage: 'Search failed'
    }),
    iconType: "warning"
  }, /*#__PURE__*/_react.default.createElement("p", null, clusterFailure.reason.reason ? `${clusterFailure.reason.type}: "${clusterFailure.reason.reason}"` : clusterFailure.reason.type), clusterFailure.reason.failed_shards ? /*#__PURE__*/_react.default.createElement(_shards_view.OpenShardFailureFlyoutButton, {
    failures: clusterFailure.reason.failed_shards
  }) : null) : null, /*#__PURE__*/_react.default.createElement(_shards_view.ShardsView, {
    failures: shardFailures,
    shardStats: clusterDetails._shards
  }));
}