"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HEALTH_HEX_CODES = void 0;
exports.getHeathBarLinearGradient = getHeathBarLinearGradient;
var _uiTheme = require("@kbn/ui-theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const HEALTH_HEX_CODES = exports.HEALTH_HEX_CODES = {
  successful: _uiTheme.euiThemeVars.euiColorSuccess,
  partial: _uiTheme.euiThemeVars.euiColorWarning,
  skipped: '#DA8B45',
  failed: _uiTheme.euiThemeVars.euiColorDanger
};
function getHeathBarLinearGradient(successful, partial, skipped, failed) {
  const total = successful + partial + skipped + failed;
  const stops = [];
  let startPercent = 0;
  function addStop(value, color) {
    if (value <= 0) {
      return;
    }
    const percent = Math.round(value / total * 100);
    const endPercent = startPercent + percent;
    stops.push(`${color} ${startPercent}% ${endPercent}%`);
    startPercent = endPercent;
  }
  addStop(successful, HEALTH_HEX_CODES.successful);
  addStop(partial, HEALTH_HEX_CODES.partial);
  addStop(skipped, HEALTH_HEX_CODES.skipped);
  addStop(failed, HEALTH_HEX_CODES.failed);
  const printedStops = stops.map((stop, index) => {
    return index === stops.length - 1 ? stop : stop + ', ';
  }).join('');
  return `linear-gradient(to right, ${printedStops})`;
}