"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClustersHealth = ClustersHealth;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _uiTheme = require("@kbn/ui-theme");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _cluster_health = require("./cluster_health");
var _gradient = require("./gradient");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

function ClustersHealth({
  clusters
}) {
  let successful = 0;
  let partial = 0;
  let skipped = 0;
  let failed = 0;
  Object.values(clusters).forEach(clusterDetails => {
    if (clusterDetails.status === 'successful') {
      successful++;
    } else if (clusterDetails.status === 'partial') {
      partial++;
    } else if (clusterDetails.status === 'skipped') {
      skipped++;
    } else if (clusterDetails.status === 'failed') {
      failed++;
    }
  });
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, _i18n.i18n.translate('inspector.requests.clusters.totalClustersLabel', {
    defaultMessage: '{total} {total, plural, one {cluster} other {clusters}}',
    values: {
      total: Object.keys(clusters).length
    }
  }))), successful > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: successful,
    status: "successful"
  })) : null, partial > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: partial,
    status: "partial"
  })) : null, skipped > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: skipped,
    status: "skipped"
  })) : null, failed > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_cluster_health.ClusterHealth, {
    count: failed,
    status: "failed"
  })) : null), /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
          background: ${(0, _gradient.getHeathBarLinearGradient)(successful, partial, skipped, failed)};
          border-radius: ${_uiTheme.euiThemeVars.euiBorderRadiusSmall};
          height: ${_uiTheme.euiThemeVars.euiSizeS};
          margin-top: ${_uiTheme.euiThemeVars.euiSizeXS};
          margin-bottom: ${_uiTheme.euiThemeVars.euiSizeS};
        `
  }));
}