"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterHealth = ClusterHealth;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _gradient = require("./gradient");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultTextProps = {
  size: 'xs',
  color: 'subdued'
};
function ClusterHealth({
  count,
  status,
  textProps = defaultTextProps
}) {
  if (typeof count === 'number' && count === 0) {
    return null;
  }
  let color = 'subdued';
  let statusLabel = status;
  if (status === 'successful') {
    color = _gradient.HEALTH_HEX_CODES.successful;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.successfulLabel', {
      defaultMessage: 'successful'
    });
  } else if (status === 'partial') {
    color = _gradient.HEALTH_HEX_CODES.partial;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.partialLabel', {
      defaultMessage: 'partial'
    });
  } else if (status === 'skipped') {
    color = _gradient.HEALTH_HEX_CODES.skipped;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.skippedLabel', {
      defaultMessage: 'skipped'
    });
  } else if (status === 'failed') {
    color = _gradient.HEALTH_HEX_CODES.failed;
    statusLabel = _i18n.i18n.translate('inspector.requests.clusters.failedLabel', {
      defaultMessage: 'failed'
    });
  }
  const label = typeof count === 'number' ? `${count} ${statusLabel}` : statusLabel;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiHealth, {
    color: color
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, textProps, label));
}