"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  plugin: true,
  Plugin: true,
  RequestAdapter: true,
  RequestStatus: true,
  RequestResponder: true,
  apiHasInspectorAdapters: true
};
Object.defineProperty(exports, "Plugin", {
  enumerable: true,
  get: function () {
    return _plugin.InspectorPublicPlugin;
  }
});
Object.defineProperty(exports, "RequestAdapter", {
  enumerable: true,
  get: function () {
    return _common.RequestAdapter;
  }
});
Object.defineProperty(exports, "RequestResponder", {
  enumerable: true,
  get: function () {
    return _common.RequestResponder;
  }
});
Object.defineProperty(exports, "RequestStatus", {
  enumerable: true,
  get: function () {
    return _common.RequestStatus;
  }
});
Object.defineProperty(exports, "apiHasInspectorAdapters", {
  enumerable: true,
  get: function () {
    return _has_inspector_adapters.apiHasInspectorAdapters;
  }
});
exports.plugin = plugin;
require("./index.scss");
var _plugin = require("./plugin");
var _common = require("../common");
var _has_inspector_adapters = require("./adapters/has_inspector_adapters");
var _types = require("./types");
Object.keys(_types).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _types[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _types[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// TODO: https://github.com/elastic/kibana/issues/109900
/* eslint-disable @kbn/eslint/no_export_all */

function plugin(initializerContext) {
  return new _plugin.InspectorPublicPlugin(initializerContext);
}