"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerListDatabaseRoute = void 0;
var _serialization = require("./serialization");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerListDatabaseRoute = ({
  router,
  lib: {
    handleEsError
  }
}) => {
  router.get({
    path: `${_constants.API_BASE_PATH}/databases`,
    validate: false
  }, async (ctx, req, res) => {
    const {
      client: clusterClient
    } = (await ctx.core).elasticsearch;
    try {
      const data = await clusterClient.asCurrentUser.ingest.getGeoipDatabase();
      const geoipDatabases = data.databases;
      return res.ok({
        body: geoipDatabases.map(_serialization.deserializeGeoipDatabase)
      });
    } catch (error) {
      const esErrorResponse = handleEsError({
        error,
        response: res
      });
      if (esErrorResponse.status === 404) {
        // ES returns 404 when there are no pipelines
        // Instead, we return an empty array and 200 status back to the client
        return res.ok({
          body: []
        });
      }
      return esErrorResponse;
    }
  });
};
exports.registerListDatabaseRoute = registerListDatabaseRoute;