"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDeleteDatabaseRoute = void 0;
var _configSchema = require("@kbn/config-schema");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const paramsSchema = _configSchema.schema.object({
  database_id: _configSchema.schema.string()
});
const registerDeleteDatabaseRoute = ({
  router,
  lib: {
    handleEsError
  }
}) => {
  router.delete({
    path: `${_constants.API_BASE_PATH}/databases/{database_id}`,
    validate: {
      params: paramsSchema
    }
  }, async (ctx, req, res) => {
    const {
      client: clusterClient
    } = (await ctx.core).elasticsearch;
    const {
      database_id: databaseID
    } = req.params;
    try {
      await clusterClient.asCurrentUser.ingest.deleteGeoipDatabase({
        id: databaseID
      });
      return res.ok();
    } catch (error) {
      return handleEsError({
        error,
        response: res
      });
    }
  });
};
exports.registerDeleteDatabaseRoute = registerDeleteDatabaseRoute;