"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelinesCsvUploader = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _types = require("../../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getOptions(actions) {
  return actions.map(action => ({
    id: action,
    label: action === _types.FieldCopyAction.Copy ? 'Copy field name' : 'Rename field'
  }));
}
const PipelinesCsvUploader = ({
  actionOptions,
  onFilePickerChange,
  onFileUpload,
  isLoading,
  isUploaded,
  hasError,
  hasFile
}) => {
  const [action, setAction] = (0, _react.useState)(_types.FieldCopyAction.Copy);
  const {
    services
  } = (0, _shared_imports.useKibana)();
  const maxFileSize = services.fileUpload.getMaxBytesFormatted();
  const options = getOptions(actionOptions);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.createFromCsv.fileUpload.filePickerTitle",
      defaultMessage: "Upload file (up to {maxFileSize})",
      values: {
        maxFileSize
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    id: "filePicker",
    "data-test-subj": "csvFilePicker",
    initialPromptText: _i18n.i18n.translate('xpack.ingestPipelines.createFromCsv.fileUpload.selectOrDragAndDropFileDescription', {
      defaultMessage: 'Select or drag and drop a CSV file'
    }),
    onChange: onFilePickerChange,
    accept: ".csv"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: /*#__PURE__*/_react.default.createElement("p", null, "Default action", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      type: "iInCircle",
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.ingestPipelines.createFromCsv.fileUpload.settingDescription",
        defaultMessage: "Whether to copy or rename the field if no action is specified in the CSV."
      })
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: options,
    idSelected: action,
    onChange: id => setAction(id)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: () => onFileUpload(action),
    isLoading: isLoading,
    isDisabled: !hasFile || isUploaded || hasError,
    "data-test-subj": "processFileButton",
    fill: true
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.createFromCsv.fileUpload.processButton",
    defaultMessage: "Process CSV"
  }))));
};
exports.PipelinesCsvUploader = PipelinesCsvUploader;