"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.serialize = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertProcessorInternalToProcessor = (processor, copyIdToTag) => {
  const {
    options,
    onFailure,
    type,
    id
  } = processor;
  const outProcessor = {
    [type]: {
      ...options
    }
  };
  if (onFailure !== null && onFailure !== void 0 && onFailure.length) {
    outProcessor[type].on_failure = convertProcessors(onFailure, copyIdToTag);
  }
  if (copyIdToTag) {
    outProcessor[type].tag = id;
  }
  return outProcessor;
};
const convertProcessors = (processors, copyIdToTag) => {
  const convertedProcessors = [];
  for (const processor of processors) {
    convertedProcessors.push(convertProcessorInternalToProcessor(processor, copyIdToTag));
  }
  return convertedProcessors;
};
const serialize = ({
  pipeline: {
    processors,
    onFailure
  },
  copyIdToTag = false
}) => {
  return {
    processors: convertProcessors(processors, copyIdToTag),
    on_failure: onFailure !== null && onFailure !== void 0 && onFailure.length ? convertProcessors(onFailure, copyIdToTag) : undefined
  };
};
exports.serialize = serialize;