"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Redact = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var _field_components = require("../field_components");
var _field_name_field = require("./common_fields/field_name_field");
var _ignore_missing_field = require("./common_fields/ignore_missing_field");
var _shared = require("./shared");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  isJsonField,
  emptyField
} = _shared_imports.fieldValidators;
const i18nTexts = {
  addPatternLabel: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternsAddPatternLabel', {
    defaultMessage: 'Add pattern'
  })
};
const valueRequiredMessage = _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternsValueRequiredError', {
  defaultMessage: 'A value is required.'
});
const patternsValidation = ({
  value
}) => {
  if (typeof value === 'string' && value.length === 0) {
    return {
      message: valueRequiredMessage
    };
  }
};
const patternValidations = [emptyField(valueRequiredMessage)];
const fieldsConfig = {
  /* Required field configs */
  patterns: {
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternsFieldLabel', {
      defaultMessage: 'Patterns'
    }),
    deserializer: String,
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternsHelpText', {
      defaultMessage: 'A list of grok expressions to match and redact named captures with.'
    }),
    validations: [{
      validator: patternsValidation
    }]
  },
  /* Optional field configs */
  pattern_definitions: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    deserializer: _shared.to.jsonString,
    serializer: _shared.from.optionalJson,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternDefinitionsLabel', {
      defaultMessage: 'Pattern definitions (optional)'
    }),
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternDefinitionsHelpText', {
      defaultMessage: 'A map of pattern-name and pattern tuples defining custom patterns to be used by the processor. Patterns matching existing names will override the pre-existing definition.'
    }),
    validations: [{
      validator: isJsonField(_i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternsDefinitionsInvalidJSONError', {
        defaultMessage: 'Invalid JSON'
      }), {
        allowEmptyString: true
      })
    }]
  },
  prefix: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.prefixLabel', {
      defaultMessage: 'Prefix (optional)'
    }),
    deserializer: String,
    serializer: _shared.from.undefinedIfValue(''),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.redactForm.prefixFieldHelpText",
      defaultMessage: "Start a redacted section with this token. If not specified, defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '<')
      }
    })
  },
  suffix: {
    type: _shared_imports.FIELD_TYPES.TEXT,
    label: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.suffixLabel', {
      defaultMessage: 'Suffix (optional)'
    }),
    deserializer: String,
    serializer: _shared.from.undefinedIfValue(''),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ingestPipelines.pipelineEditor.redactForm.suffixFieldHelpText",
      defaultMessage: "End a redacted section with this token. If not specified, defaults to {defaultValue}.",
      values: {
        defaultValue: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, '>')
      }
    })
  }
};
const Redact = () => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_field_name_field.FieldNameField, {
    helpText: _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.fieldNameHelpText', {
      defaultMessage: 'Field to be redacted.'
    })
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseArray, {
    path: "fields.patterns",
    validations: fieldsConfig.patterns.validations
  }, ({
    items,
    addItem,
    removeItem,
    error
  }) => {
    var _fieldsConfig$pattern, _fieldsConfig$pattern2;
    return /*#__PURE__*/_react.default.createElement(_field_components.InputList, {
      label: fieldsConfig.patterns.label,
      helpText: typeof fieldsConfig.patterns.helpText === 'function' ? fieldsConfig.patterns.helpText() : fieldsConfig.patterns.helpText,
      error: error,
      value: items,
      onAdd: addItem,
      onRemove: removeItem,
      addLabel: i18nTexts.addPatternLabel,
      textValidations: patternValidations,
      textDeserializer: (_fieldsConfig$pattern = fieldsConfig.patterns) === null || _fieldsConfig$pattern === void 0 ? void 0 : _fieldsConfig$pattern.deserializer,
      textSerializer: (_fieldsConfig$pattern2 = fieldsConfig.patterns) === null || _fieldsConfig$pattern2 === void 0 ? void 0 : _fieldsConfig$pattern2.serializer
    });
  }), /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    component: _field_components.XJsonEditor,
    config: fieldsConfig.pattern_definitions,
    componentProps: {
      editorProps: {
        'data-test-subj': 'patternDefinitionsField',
        height: _shared.EDITOR_PX_HEIGHT.medium,
        'aria-label': _i18n.i18n.translate('xpack.ingestPipelines.pipelineEditor.redactForm.patternDefinitionsAriaLabel', {
          defaultMessage: 'Pattern definitions editor'
        })
      }
    },
    path: "fields.pattern_definitions"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.prefix,
    component: _shared_imports.Field,
    path: "fields.prefix",
    "data-test-subj": "prefixField"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    config: fieldsConfig.suffix,
    component: _shared_imports.Field,
    path: "fields.suffix",
    "data-test-subj": "suffixField"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_ignore_missing_field.IgnoreMissingField, null));
};
exports.Redact = Redact;