"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddProcessorForm = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _shared = require("../shared");
var _documentation_button = require("./documentation_button");
var _processor_settings_fields = require("./processor_settings_fields");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const addButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.addProcessorFormOnFailureFlyout.addButtonLabel', {
  defaultMessage: 'Add processor'
});
const cancelButtonLabel = _i18n.i18n.translate('xpack.ingestPipelines.addProcesorFormOnFailureFlyout.cancelButtonLabel', {
  defaultMessage: 'Cancel'
});
const getFlyoutTitle = isOnFailure => {
  return isOnFailure ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.configureOnFailureTitle",
    defaultMessage: "Add on-failure processor"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ingestPipelines.settingsFormOnFailureFlyout.configureTitle",
    defaultMessage: "Add processor"
  });
};
const AddProcessorForm = ({
  isOnFailure,
  onOpen,
  form,
  esDocsBasePath,
  closeFlyout,
  handleSubmit
}) => {
  (0, _react.useEffect)(() => {
    onOpen();
  }, [] /* eslint-disable-line react-hooks/exhaustive-deps */);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    "data-test-subj": "addProcessorForm",
    form: form,
    onSubmit: handleSubmit
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    size: "m",
    maxWidth: 720,
    onClose: closeFlyout
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "configurePipelineHeader"
  }, /*#__PURE__*/_react.default.createElement("h2", null, getFlyoutTitle(isOnFailure))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "type"
  }, ({
    type
  }) => {
    const formDescriptor = (0, _shared.getProcessorDescriptor)(type);
    if (formDescriptor) {
      return /*#__PURE__*/_react.default.createElement(_documentation_button.DocumentationButton, {
        processorLabel: formDescriptor.label,
        docLink: esDocsBasePath + formDescriptor.docLinkPath
      });
    }
    return null;
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_processor_settings_fields.ProcessorSettingsFields, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: closeFlyout
  }, cancelButtonLabel)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    disabled: !form.isValid && form.isSubmitted || form.isSubmitting,
    "data-test-subj": "submitButton",
    onClick: async () => {
      await handleSubmit();
    }
  }, addButtonLabel))))));
};
exports.AddProcessorForm = AddProcessorForm;