"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getHostsAlertsCount = getHostsAlertsCount;
var _server = require("@kbn/observability-plugin/server");
var _common = require("@kbn/observability-shared-plugin/common");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _constants = require("../../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getHostsAlertsCount({
  alertsClient,
  hostNames,
  from,
  to,
  limit
}) {
  var _result$aggregations$, _result$aggregations;
  const rangeQuery = [{
    range: {
      'kibana.alert.time_range': {
        gte: from,
        lte: to
      }
    }
  }];
  const params = {
    size: 0,
    track_total_hits: false,
    query: {
      bool: {
        filter: [...(0, _server.termsQuery)(_ruleDataUtils.ALERT_RULE_PRODUCER, _constants.INFRA_ALERT_FEATURE_ID, _common.observabilityFeatureId), ...(0, _server.termQuery)(_ruleDataUtils.ALERT_STATUS, _ruleDataUtils.ALERT_STATUS_ACTIVE), ...(0, _server.termsQuery)(_constants.HOST_NAME_FIELD, ...hostNames), ...rangeQuery]
      }
    },
    aggs: {
      hosts: {
        terms: {
          field: _constants.HOST_NAME_FIELD,
          size: limit,
          order: {
            _key: 'asc'
          }
        },
        aggs: {
          alerts_count: {
            cardinality: {
              field: _ruleDataUtils.ALERT_UUID
            }
          }
        }
      }
    }
  };
  const result = await alertsClient.search(params);
  const filterAggBuckets = (_result$aggregations$ = (_result$aggregations = result.aggregations) === null || _result$aggregations === void 0 ? void 0 : _result$aggregations.hosts.buckets) !== null && _result$aggregations$ !== void 0 ? _result$aggregations$ : [];
  return filterAggBuckets.map(bucket => ({
    name: bucket.key,
    alertsCount: bucket.alerts_count.value
  }));
}