"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLatestEntity = getLatestEntity;
var _entitiesSchema = require("@kbn/entities-schema");
var _elasticsearch = require("@kbn/observability-shared-plugin/common/field_names/elasticsearch");
var _esql_result_to_plain_objects = require("@kbn/observability-utils/es/utils/esql_result_to_plain_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ENTITIES_LATEST_ALIAS = (0, _entitiesSchema.entitiesAliasPattern)({
  type: '*',
  dataset: _entitiesSchema.ENTITY_LATEST
});
async function getLatestEntity({
  inventoryEsClient,
  entityId,
  entityType,
  entityManagerClient
}) {
  var _definitions$, _definitions$$identit, _definitions$$identit2;
  const {
    definitions
  } = await entityManagerClient.getEntityDefinitions({
    builtIn: true,
    type: entityType
  });
  const hostOrContainerIdentityField = (_definitions$ = definitions[0]) === null || _definitions$ === void 0 ? void 0 : (_definitions$$identit = _definitions$.identityFields) === null || _definitions$$identit === void 0 ? void 0 : (_definitions$$identit2 = _definitions$$identit[0]) === null || _definitions$$identit2 === void 0 ? void 0 : _definitions$$identit2.field;
  if (hostOrContainerIdentityField === undefined) {
    return {
      [_elasticsearch.SOURCE_DATA_STREAM_TYPE]: []
    };
  }
  const latestEntitiesEsqlResponse = await inventoryEsClient.esql('get_latest_entities', {
    query: `FROM ${ENTITIES_LATEST_ALIAS}
        | WHERE ${_elasticsearch.ENTITY_TYPE} == ?
        | WHERE ${hostOrContainerIdentityField} == ?
        | KEEP ${_elasticsearch.SOURCE_DATA_STREAM_TYPE}
      `,
    params: [entityType, entityId]
  });
  return (0, _esql_result_to_plain_objects.esqlResultToPlainObjects)(latestEntitiesEsqlResponse)[0];
}