"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDataStreamTypes = getDataStreamTypes;
var _common = require("@kbn/metrics-data-access-plugin/common");
var _common2 = require("@kbn/observability-shared-plugin/common");
var _get_has_metrics_data = require("./get_has_metrics_data");
var _get_latest_entity = require("./get_latest_entity");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getDataStreamTypes({
  entityCentriExperienceEnabled,
  entityId,
  entityManagerClient,
  entityType,
  infraMetricsClient,
  obsEsClient
}) {
  const hasMetricsData = await (0, _get_has_metrics_data.getHasMetricsData)({
    infraMetricsClient,
    entityId,
    field: (0, _common.findInventoryFields)(entityType).id
  });
  const sourceDataStreams = new Set(hasMetricsData ? [_common2.EntityDataStreamType.METRICS] : []);
  if (!entityCentriExperienceEnabled) {
    return Array.from(sourceDataStreams);
  }
  const entity = await (0, _get_latest_entity.getLatestEntity)({
    inventoryEsClient: obsEsClient,
    entityId,
    entityType,
    entityManagerClient
  });
  if (entity !== null && entity !== void 0 && entity[_common2.SOURCE_DATA_STREAM_TYPE]) {
    [entity[_common2.SOURCE_DATA_STREAM_TYPE]].flat().forEach(item => {
      sourceDataStreams.add(item);
    });
  }
  return Array.from(sourceDataStreams);
}