"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.checkCustomDashboardsEnabled = checkCustomDashboardsEnabled;
var _boom = _interopRequireDefault(require("@hapi/boom"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function checkCustomDashboardsEnabled(uiSettingsClient) {
  const isEnabled = await uiSettingsClient.get(_common.enableInfrastructureAssetCustomDashboards);
  if (!isEnabled) {
    throw _boom.default.forbidden(_i18n.i18n.translate('xpack.infra.routes.customDashboards', {
      defaultMessage: 'Custom dashboards are not enabled'
    }));
  }
}