"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initGetCustomDashboardRoute = initGetCustomDashboardRoute;
var _ioTsUtils = require("@kbn/io-ts-utils");
var _custom_dashboards_api = require("../../../common/http_api/custom_dashboards_api");
var _handle_route_errors = require("../../utils/handle_route_errors");
var _check_custom_dashboards_enabled = require("./lib/check_custom_dashboards_enabled");
var _find_custom_dashboard = require("./lib/find_custom_dashboard");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function initGetCustomDashboardRoute(framework) {
  const validateParams = (0, _ioTsUtils.createRouteValidationFunction)(_custom_dashboards_api.InfraGetCustomDashboardsRequestPathParamsRT);
  framework.registerRoute({
    method: 'get',
    path: '/api/infra/{assetType}/custom-dashboards',
    validate: {
      params: validateParams
    },
    options: {
      access: 'internal'
    }
  }, (0, _handle_route_errors.handleRouteErrors)(async (context, request, response) => {
    const {
      savedObjectsClient,
      uiSettingsClient
    } = await context.infra;
    await (0, _check_custom_dashboards_enabled.checkCustomDashboardsEnabled)(uiSettingsClient);
    const params = request.params;
    const customDashboards = await (0, _find_custom_dashboard.findCustomDashboard)(params.assetType, savedObjectsClient);
    return response.ok({
      body: _custom_dashboards_api.InfraGetCustomDashboardsResponseBodyRT.encode(customDashboards)
    });
  }));
}