"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInfraMetricsClient = getInfraMetricsClient;
var _ui_settings_keys = require("@kbn/observability-plugin/common/ui_settings_keys");
var _exclude_tiers_query = require("@kbn/observability-utils/es/queries/exclude_tiers_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInfraMetricsClient({
  libs,
  context,
  request
}) {
  const {
    framework
  } = libs;
  const infraContext = await context.infra;
  const {
    uiSettings
  } = await context.core;
  const excludedDataTiers = await uiSettings.client.get(_ui_settings_keys.searchExcludedDataTiers);
  const metricsIndices = await infraContext.getMetricsIndices();
  const excludedQuery = excludedDataTiers.length ? (0, _exclude_tiers_query.excludeTiersQuery)(excludedDataTiers)[0].bool.must_not : [];
  return {
    search(searchParams) {
      var _searchParams$body$qu, _searchParams$body$qu2, _searchParams$body$qu3, _searchParams$body$qu4;
      const searchFilter = (_searchParams$body$qu = (_searchParams$body$qu2 = searchParams.body.query) === null || _searchParams$body$qu2 === void 0 ? void 0 : (_searchParams$body$qu3 = _searchParams$body$qu2.bool) === null || _searchParams$body$qu3 === void 0 ? void 0 : _searchParams$body$qu3.must_not) !== null && _searchParams$body$qu !== void 0 ? _searchParams$body$qu : [];

      // This flattens arrays by one level, and non-array values can be added as well, so it all
      // results in a nice [QueryDsl, QueryDsl, ...] array.
      const mustNot = [].concat(searchFilter, excludedQuery);
      return framework.callWithRequest(context, 'search', {
        ...searchParams,
        ignore_unavailable: true,
        index: metricsIndices,
        body: {
          ...searchParams.body,
          query: {
            ...searchParams.body.query,
            bool: {
              ...((_searchParams$body$qu4 = searchParams.body.query) === null || _searchParams$body$qu4 === void 0 ? void 0 : _searchParams$body$qu4.bool),
              must_not: mustNot
            }
          }
        }
      }, request);
    }
  };
}