"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.METRICS_FEATURE = exports.LOGS_FEATURE = void 0;
var _i18n = require("@kbn/i18n");
var _server = require("@kbn/core/server");
var _server2 = require("@kbn/logs-shared-plugin/server");
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _server3 = require("@kbn/metrics-data-access-plugin/server");
var _common = require("@kbn/features-plugin/common");
var _types = require("../common/alerting/logs/log_threshold/types");
var _metrics = require("../common/alerting/metrics");
var _constants = require("../common/constants");
var _saved_object_type = require("./lib/sources/saved_object_type");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const metricRuleTypes = [_metrics.METRIC_THRESHOLD_ALERT_TYPE_ID, _metrics.METRIC_INVENTORY_THRESHOLD_ALERT_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID];
const METRICS_FEATURE = exports.METRICS_FEATURE = {
  id: _constants.METRICS_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.infra.featureRegistry.linkInfrastructureTitle', {
    defaultMessage: 'Infrastructure'
  }),
  order: 800,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: ['infra', 'metrics', 'kibana'],
  catalogue: ['infraops', 'metrics'],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: metricRuleTypes,
  privileges: {
    all: {
      app: ['infra', 'metrics', 'kibana'],
      catalogue: ['infraops', 'metrics'],
      api: ['infra', 'rac'],
      savedObject: {
        all: ['infrastructure-ui-source', _server3.metricsDataSourceSavedObjectName],
        read: ['index-pattern']
      },
      alerting: {
        rule: {
          all: metricRuleTypes
        },
        alert: {
          all: metricRuleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'configureSource', 'save']
    },
    read: {
      app: ['infra', 'metrics', 'kibana'],
      catalogue: ['infraops', 'metrics'],
      api: ['infra', 'rac'],
      savedObject: {
        all: [],
        read: ['infrastructure-ui-source', 'index-pattern', _server3.metricsDataSourceSavedObjectName]
      },
      alerting: {
        rule: {
          read: metricRuleTypes
        },
        alert: {
          read: metricRuleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show']
    }
  }
};
const logsRuleTypes = [_types.LOG_DOCUMENT_COUNT_RULE_TYPE_ID, _ruleDataUtils.ES_QUERY_ID, _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID, _ruleDataUtils.ML_ANOMALY_DETECTION_RULE_TYPE_ID];
const LOGS_FEATURE = exports.LOGS_FEATURE = {
  id: _constants.LOGS_FEATURE_ID,
  name: _i18n.i18n.translate('xpack.infra.featureRegistry.linkLogsTitle', {
    defaultMessage: 'Logs'
  }),
  order: 700,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
  catalogue: ['infralogging', 'logs'],
  management: {
    insightsAndAlerting: ['triggersActions']
  },
  alerting: logsRuleTypes,
  privileges: {
    all: {
      app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
      catalogue: ['infralogging', 'logs'],
      api: ['infra', 'rac'],
      savedObject: {
        all: [_saved_object_type.infraSourceConfigurationSavedObjectName, _server2.logViewSavedObjectName],
        read: []
      },
      alerting: {
        rule: {
          all: logsRuleTypes
        },
        alert: {
          all: logsRuleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      ui: ['show', 'configureSource', 'save']
    },
    read: {
      app: ['infra', 'logs', 'kibana', 'observability-logs-explorer'],
      catalogue: ['infralogging', 'logs'],
      api: ['infra', 'rac'],
      alerting: {
        rule: {
          read: logsRuleTypes
        },
        alert: {
          read: logsRuleTypes
        }
      },
      management: {
        insightsAndAlerting: ['triggersActions']
      },
      savedObject: {
        all: [],
        read: [_saved_object_type.infraSourceConfigurationSavedObjectName, _server2.logViewSavedObjectName]
      },
      ui: ['show']
    }
  }
};