"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateBoundsFromNodes = void 0;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const calculateBoundsFromNodes = nodes => {
  const values = nodes.map(node => {
    const metric = (0, _lodash.first)(node.metrics);
    return !metric || !metric.value ? 0 : metric.value;
  });
  // if there is only one value then we need to set the bottom range to zero for min
  // otherwise the legend will look silly since both values are the same for top and
  // bottom.
  if (values.length === 1) {
    values.unshift(0);
  }
  const maxValue = (0, _lodash.max)(values) || 0;
  const minValue = (0, _lodash.min)(values) || 0;
  return {
    min: (0, _lodash.isFinite)(minValue) ? minValue : 0,
    max: (0, _lodash.isFinite)(maxValue) ? maxValue : 0
  };
};
exports.calculateBoundsFromNodes = calculateBoundsFromNodes;