"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useWaffleViewState = exports.DEFAULT_WAFFLE_VIEW_STATE = void 0;
var _react = require("react");
var _use_waffle_options = require("./use_waffle_options");
var _use_waffle_time = require("./use_waffle_time");
var _use_waffle_filters = require("./use_waffle_filters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_WAFFLE_VIEW_STATE = exports.DEFAULT_WAFFLE_VIEW_STATE = {
  ..._use_waffle_options.DEFAULT_WAFFLE_OPTIONS_STATE,
  filterQuery: _use_waffle_filters.DEFAULT_WAFFLE_FILTERS_STATE,
  time: _use_waffle_time.DEFAULT_WAFFLE_TIME_STATE.currentTime,
  autoReload: _use_waffle_time.DEFAULT_WAFFLE_TIME_STATE.isAutoReloading
};
const useWaffleViewState = () => {
  const {
    metric,
    groupBy,
    nodeType,
    view,
    customOptions,
    customMetrics,
    boundsOverride,
    autoBounds,
    accountId,
    region,
    legend,
    sort,
    timelineOpen,
    setWaffleOptionsState
  } = (0, _use_waffle_options.useWaffleOptionsContext)();
  const {
    currentTime,
    isAutoReloading,
    setWaffleTimeState
  } = (0, _use_waffle_time.useWaffleTimeContext)();
  const {
    filterQuery,
    setWaffleFiltersState
  } = (0, _use_waffle_filters.useWaffleFiltersContext)();
  const viewState = {
    metric,
    sort,
    groupBy,
    nodeType,
    view,
    customOptions,
    customMetrics,
    boundsOverride,
    autoBounds,
    accountId,
    region,
    time: currentTime,
    autoReload: isAutoReloading,
    filterQuery,
    legend,
    timelineOpen
  };
  const onViewChange = (0, _react.useCallback)(newState => {
    const attributes = newState.attributes;
    setWaffleOptionsState({
      sort: attributes.sort,
      metric: attributes.metric,
      groupBy: attributes.groupBy,
      nodeType: attributes.nodeType,
      view: attributes.view,
      customOptions: attributes.customOptions,
      customMetrics: attributes.customMetrics,
      boundsOverride: attributes.boundsOverride,
      autoBounds: attributes.autoBounds,
      accountId: attributes.accountId,
      region: attributes.region,
      legend: attributes.legend,
      timelineOpen: attributes.timelineOpen
    });
    if (attributes.time) {
      setWaffleTimeState({
        currentTime: attributes.time,
        isAutoReloading: attributes.autoReload
      });
    }
    setWaffleFiltersState(attributes.filterQuery);
  }, [setWaffleOptionsState, setWaffleTimeState, setWaffleFiltersState]);
  return {
    viewState,
    defaultViewState: DEFAULT_WAFFLE_VIEW_STATE,
    onViewChange
  };
};
exports.useWaffleViewState = useWaffleViewState;