"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HostsPage = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/observability-shared-plugin/public");
var _public2 = require("@kbn/core/public");
var _react2 = require("@emotion/react");
var _no_data_config = require("../../../components/shared/templates/no_data_config");
var _infra_page_template = require("../../../components/shared/templates/infra_page_template");
var _constants = require("../../../../common/constants");
var _use_kibana = require("../../../hooks/use_kibana");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _translations = require("../../../translations");
var _page_template = require("../../../page_template.styles");
var _hosts_container = require("./components/hosts_container");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HOSTS_FEEDBACK_LINK = 'https://docs.google.com/forms/d/e/1FAIpQLScRHG8TIVb1Oq8ZhD4aks3P1TmgiM58TY123QpDCcBz83YC6w/viewform';
const DATA_AVAILABILITY_MODULES = [_constants.SYSTEM_INTEGRATION];
const HostsPage = () => {
  const {
    kibanaVersion,
    isCloudEnv,
    isServerlessEnv
  } = (0, _use_kibana.useKibanaEnvironmentContext)();
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts'
  });
  (0, _public.useTrackPageview)({
    app: 'infra_metrics',
    path: 'hosts',
    delay: 15000
  });
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    text: _translations.hostsTitle
  }]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiErrorBoundary, null, /*#__PURE__*/_react.default.createElement("div", {
    className: _public2.APP_WRAPPER_CLASS
  }, /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    dataAvailabilityModules: DATA_AVAILABILITY_MODULES,
    onboardingFlow: _no_data_config.OnboardingFlow.Hosts,
    pageHeader: {
      alignItems: 'center',
      pageTitle: /*#__PURE__*/_react.default.createElement("div", {
        css: (0, _react2.css)`
                  display: flex;
                  align-items: center;
                  gap: 0.75rem;
                `
      }, /*#__PURE__*/_react.default.createElement("h1", null, _translations.hostsTitle)),
      rightSideItems: [/*#__PURE__*/_react.default.createElement(_public.FeatureFeedbackButton, {
        "data-test-subj": "infraHostsPageTellUsWhatYouThinkButton",
        formUrl: HOSTS_FEEDBACK_LINK,
        kibanaVersion: kibanaVersion,
        isCloudEnv: isCloudEnv,
        isServerlessEnv: isServerlessEnv
      })]
    },
    pageSectionProps: {
      contentProps: {
        css: _page_template.fullHeightContentStyles
      }
    }
  }, /*#__PURE__*/_react.default.createElement(_hosts_container.HostContainer, null))));
};
exports.HostsPage = HostsPage;