"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useHostCountContext = exports.useHostCount = exports.HostCountProvider = exports.HostCount = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _react = require("react");
var _http_api = require("../../../../../common/http_api");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_unified_search = require("./use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useHostCount = () => {
  var _data$count;
  const {
    buildQuery,
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const payload = (0, _react.useMemo)(() => JSON.stringify({
    query: buildQuery(),
    from: parsedDateRange.from,
    to: parsedDateRange.to
  }), [buildQuery, parsedDateRange]);
  const {
    data,
    status,
    error
  } = (0, _use_fetcher.useFetcher)(async callApi => {
    const response = await callApi('/api/infra/host/count', {
      method: 'POST',
      body: payload
    });
    return (0, _ioTsUtils.decodeOrThrow)(_http_api.GetInfraAssetCountResponsePayloadRT)(response);
  }, [payload]);
  return {
    errors: error,
    loading: (0, _use_fetcher.isPending)(status),
    count: (_data$count = data === null || data === void 0 ? void 0 : data.count) !== null && _data$count !== void 0 ? _data$count : 0
  };
};
exports.useHostCount = useHostCount;
const HostCount = exports.HostCount = (0, _constate.default)(useHostCount);
const [HostCountProvider, useHostCountContext] = HostCount;
exports.useHostCountContext = useHostCountContext;
exports.HostCountProvider = HostCountProvider;