"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EntryTitle = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _customIcons = require("@kbn/custom-icons");
var _public = require("@kbn/metrics-data-access-plugin/public");
var _use_unified_search = require("../../hooks/use_unified_search");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EntryTitle = ({
  onClick,
  title
}) => {
  const {
    name,
    cloudProvider
  } = title;
  const {
    parsedDateRange
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    getAssetDetailUrl
  } = (0, _public.useAssetDetailsRedirect)();
  const link = getAssetDetailUrl({
    assetId: name,
    assetType: 'host',
    search: {
      from: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.from ? new Date(parsedDateRange === null || parsedDateRange === void 0 ? void 0 : parsedDateRange.from).getTime() : undefined,
      to: parsedDateRange !== null && parsedDateRange !== void 0 && parsedDateRange.to ? new Date(parsedDateRange.to).getTime() : undefined,
      name
    }
  });
  const providerName = cloudProvider !== null && cloudProvider !== void 0 ? cloudProvider : 'Unknown';
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "long",
    anchorClassName: "eui-displayBlock",
    content: _i18n.i18n.translate('xpack.infra.hostsViewPage.table.nameTooltip', {
      defaultMessage: '{providerName}: {name}',
      values: {
        providerName,
        name
      }
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
    "data-test-subj": "hostsViewTableEntryTitleLink"
  }, link), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "eui-textTruncate",
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    onClick: onClick
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_customIcons.CloudProviderIcon, {
    cloudProvider: cloudProvider,
    size: "m",
    title: providerName,
    role: "presentation"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    className: "eui-textTruncate"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "eui-textTruncate"
  }, name)))));
};
exports.EntryTitle = EntryTitle;