"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedSearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _use_kibana = require("../../../../../hooks/use_kibana");
var _use_unified_search = require("../../hooks/use_unified_search");
var _controls_content = require("./controls_content");
var _metrics_source = require("../../../../../containers/metrics_source");
var _limit_options = require("./limit_options");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnifiedSearchBar = () => {
  var _application$capabili, _application$capabili2;
  const {
    services: {
      unifiedSearch,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    metricsView
  } = (0, _metrics_source.useMetricsDataViewContext)();
  const {
    searchCriteria,
    onLimitChange,
    onPanelFiltersChange,
    onSubmit
  } = (0, _use_unified_search.useUnifiedSearchContext)();
  const {
    SearchBar
  } = unifiedSearch.ui;
  const handleRefresh = (0, _react.useCallback)((payload, isUpdate) => {
    // This makes sure `onSubmit` is only called when the submit button is clicked
    if (isUpdate === false) {
      onSubmit(payload);
    }
  }, [onSubmit]);
  return /*#__PURE__*/_react.default.createElement(StickyContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(SearchBar, {
    appName: 'Infra Hosts',
    displayStyle: "inPage",
    indexPatterns: metricsView && [metricsView.dataViewReference],
    placeholder: _i18n.i18n.translate('xpack.infra.hosts.searchPlaceholder', {
      defaultMessage: 'Search hosts (E.g. cloud.provider:gcp AND system.load.1 > 0.5)'
    }),
    onQuerySubmit: handleRefresh,
    saveQueryMenuVisibility: application !== null && application !== void 0 && (_application$capabili = application.capabilities) !== null && _application$capabili !== void 0 && (_application$capabili2 = _application$capabili.visualize) !== null && _application$capabili2 !== void 0 && _application$capabili2.saveQuery ? 'allowed_by_app_privilege' : 'globally_managed',
    showDatePicker: true,
    showFilterBar: true,
    showQueryInput: true,
    showQueryMenu: true,
    useDefaultBehaviors: true,
    isAutoRefreshDisabled: true,
    isRefreshPaused: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    alignItems: "center",
    wrap: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_controls_content.ControlsContent, {
    timeRange: searchCriteria.dateRange,
    dataView: metricsView === null || metricsView === void 0 ? void 0 : metricsView.dataViewReference,
    query: searchCriteria.query,
    filters: searchCriteria.filters,
    onFiltersChange: onPanelFiltersChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_limit_options.LimitOptions, {
    limit: searchCriteria.limit,
    onChange: onLimitChange
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "xs",
    css: (0, _react2.css)`
          margin-bottom: 0;
        `
  }));
};
exports.UnifiedSearchBar = UnifiedSearchBar;
const StickyContainer = ({
  children
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    css: (0, _react2.css)`
        position: sticky;
        top: var(--kbnAppHeadersOffset, var(--euiFixedHeadersOffset, 0));
        z-index: ${euiTheme.levels.navigation};
        background: ${euiTheme.colors.emptyShade};
        padding: ${euiTheme.size.l} ${euiTheme.size.l} 0px;
        margin: -${euiTheme.size.l} -${euiTheme.size.l} 0px;
        min-height: calc(${euiTheme.size.xxxl} * 2);
      `
  }, children);
};