"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchSessionContext = exports.useSearchSession = exports.SearchSessionProvider = void 0;
var _constate = _interopRequireDefault(require("constate"));
var _react = require("react");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useSearchSession = () => {
  const {
    services
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const {
    data: {
      search
    }
  } = services;
  const [searchSessionId, setSearchSessionId] = (0, _react.useState)('');
  const updateSearchSessionId = (0, _react.useCallback)(() => {
    const sessionId = search.session.start();
    setSearchSessionId(sessionId);
  }, [search.session]);
  (0, _react.useEffect)(() => {
    updateSearchSessionId();
  }, [updateSearchSessionId]);
  return {
    updateSearchSessionId,
    searchSessionId
  };
};
exports.useSearchSession = useSearchSession;
const [SearchSessionProvider, useSearchSessionContext] = (0, _constate.default)(useSearchSession);
exports.useSearchSessionContext = useSearchSessionContext;
exports.SearchSessionProvider = SearchSessionProvider;