"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProfilingIntegrationSetting = useProfilingIntegrationSetting;
var _public = require("@kbn/kibana-react-plugin/public");
var _common = require("@kbn/observability-plugin/common");
var _plugin_config_context = require("../containers/plugin_config_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useProfilingIntegrationSetting() {
  const {
    featureFlags: {
      profilingEnabled
    }
  } = (0, _plugin_config_context.usePluginConfig)();
  const isProfilingUiSettingEnabled = (0, _public.useUiSetting)(_common.enableInfrastructureProfilingIntegration);
  return profilingEnabled && isProfilingUiSettingEnabled;
}