"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedViewsToolbarControls = SavedViewsToolbarControls;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _reactHooks = require("@kbn/react-hooks");
var _manage_views_flyout = require("./manage_views_flyout");
var _upsert_modal = require("./upsert_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function SavedViewsToolbarControls(props) {
  const {
    currentView,
    views,
    isFetchingViews,
    isFetchingCurrentView,
    isCreatingView,
    isUpdatingView,
    onCreateView,
    onDeleteView,
    onUpdateView,
    onLoadViews,
    onSetDefaultView,
    onSwitchView,
    viewState
  } = props;
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  const [isManageFlyoutOpen, {
    on: openManageFlyout,
    off: closeManageFlyout
  }] = (0, _reactHooks.useBoolean)(false);
  const [isCreateModalOpen, {
    on: openCreateModal,
    off: closeCreateModal
  }] = (0, _reactHooks.useBoolean)(false);
  const [isUpdateModalOpen, {
    on: openUpdateModal,
    off: closeUpdateModal
  }] = (0, _reactHooks.useBoolean)(false);
  const togglePopoverAndLoad = () => {
    if (!isPopoverOpen) {
      onLoadViews();
    }
    togglePopover();
  };
  const goToManageViews = () => {
    closePopover();
    openManageFlyout();
  };
  const goToCreateView = () => {
    closePopover();
    openCreateModal();
  };
  const goToUpdateView = () => {
    closePopover();
    openUpdateModal();
  };
  const handleCreateView = (name, shouldIncludeTime = false) => {
    const attributes = {
      ...viewState,
      name
    };
    if (!shouldIncludeTime) {
      delete attributes.time;
    }
    onCreateView(attributes).then(closeCreateModal);
  };
  const handleUpdateView = (name, shouldIncludeTime = false) => {
    if (!currentView) return;
    const attributes = {
      ...viewState,
      name
    };
    if (!shouldIncludeTime) {
      delete attributes.time;
    }
    onUpdateView({
      id: currentView.id,
      attributes
    }).then(closeUpdateModal);
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    "data-test-subj": "savedViews-popover",
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: togglePopoverAndLoad,
      "data-test-subj": "savedViews-openPopover",
      iconType: "arrowDown",
      iconSide: "right",
      color: "text",
      isLoading: isFetchingCurrentView
    }, currentView ? currentView.attributes.name : _i18n.i18n.translate('xpack.infra.savedView.unknownView', {
      defaultMessage: 'No view selected'
    })),
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroup, {
    flush: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-manageViews",
    iconType: "indexSettings",
    onClick: goToManageViews,
    label: _i18n.i18n.translate('xpack.infra.savedView.manageViews', {
      defaultMessage: 'Manage views'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-updateView",
    iconType: "refresh",
    onClick: goToUpdateView,
    isDisabled: !currentView || currentView.attributes.isStatic,
    label: _i18n.i18n.translate('xpack.infra.savedView.updateView', {
      defaultMessage: 'Update view'
    })
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiListGroupItem, {
    "data-test-subj": "savedViews-saveNewView",
    iconType: "save",
    onClick: goToCreateView,
    label: _i18n.i18n.translate('xpack.infra.savedView.saveNewView', {
      defaultMessage: 'Save new view'
    })
  }))), isCreateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isSaving: isCreatingView,
    onClose: closeCreateModal,
    onSave: handleCreateView,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Save View",
      id: "xpack.infra.waffle.savedView.createHeader"
    })
  }), isUpdateModalOpen && /*#__PURE__*/_react.default.createElement(_upsert_modal.UpsertViewModal, {
    isSaving: isUpdatingView,
    onClose: closeUpdateModal,
    onSave: handleUpdateView,
    initialName: currentView === null || currentView === void 0 ? void 0 : currentView.attributes.name,
    initialIncludeTime: Boolean(currentView === null || currentView === void 0 ? void 0 : currentView.attributes.time),
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Update View",
      id: "xpack.infra.waffle.savedView.updateHeader"
    })
  }), isManageFlyoutOpen && /*#__PURE__*/_react.default.createElement(_manage_views_flyout.ManageViewsFlyout, {
    loading: isFetchingViews,
    views: views,
    onMakeDefaultView: onSetDefaultView,
    onDeleteView: onDeleteView,
    onClose: closeManageFlyout,
    onSwitchView: onSwitchView
  }));
}