"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LogsDeprecationCallout = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _deeplinksObservability = require("@kbn/deeplinks-observability");
var _routerUtils = require("@kbn/router-utils");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _uiTheme = require("@kbn/ui-theme");
var _css = require("@emotion/css");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _public = require("@kbn/core/public");
var _rxjs = require("rxjs");
var _use_kibana = require("../hooks/use_kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const pageConfigurations = {
  stream: {
    dismissalStorageKey: 'log_stream_deprecation_callout_dismissed',
    message: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.p.theNewLogsExplorerLabel', {
      defaultMessage: 'The new Logs Explorer makes viewing and inspecting your logs easier with more features, better performance, and more intuitive navigation. We recommend switching to Logs Explorer, as it will replace Logs Stream in a future version.'
    })
  },
  settings: {
    dismissalStorageKey: 'log_settings_deprecation_callout_dismissed',
    message: _i18n.i18n.translate('xpack.infra.logsSettingsDeprecationCallout.p.theNewLogsExplorerLabel', {
      defaultMessage: 'These settings only apply to the legacy Logs Stream app, and we do not recommend configuring them. Instead, use Logs Explorer which makes viewing and inspecting your logs easier with more features, better performance, and more intuitive navigation.'
    })
  }
};
const LogsDeprecationCallout = ({
  page
}) => {
  const {
    services: {
      share,
      application
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const isLogsExplorerAppAccessible = (0, _useObservable.default)((0, _react.useMemo)(() => application.applications$.pipe((0, _rxjs.map)(apps => {
    var _apps$get$status, _apps$get;
    return ((_apps$get$status = (_apps$get = apps.get(_deeplinksObservability.OBSERVABILITY_LOGS_EXPLORER_APP_ID)) === null || _apps$get === void 0 ? void 0 : _apps$get.status) !== null && _apps$get$status !== void 0 ? _apps$get$status : _public.AppStatus.inaccessible) === _public.AppStatus.accessible;
  })), [application.applications$]), false);
  const {
    dismissalStorageKey,
    message
  } = pageConfigurations[page];
  const [isDismissed, setDismissed] = (0, _useLocalStorage.default)(dismissalStorageKey, false);
  if (isDismissed || !isLogsExplorerAppAccessible) {
    return null;
  }
  const allDatasetLocator = share.url.locators.get(_deeplinksObservability.ALL_DATASETS_LOCATOR_ID);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.euiCallOut.discoverANewLogLabel', {
      defaultMessage: "There's a new, better way to explore your logs!"
    }),
    color: "warning",
    iconType: "iInCircle",
    heading: "h2",
    onDismiss: () => setDismissed(true),
    className: calloutStyle
  }, /*#__PURE__*/_react.default.createElement("p", null, message), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
    fill: true,
    "data-test-subj": "infraLogsDeprecationCalloutTryLogsExplorerButton",
    color: "warning"
  }, getLogsExplorerLinkProps(allDatasetLocator)), _i18n.i18n.translate('xpack.infra.logsDeprecationCallout.tryLogsExplorerButtonLabel', {
    defaultMessage: 'Try Logs Explorer'
  })));
};
exports.LogsDeprecationCallout = LogsDeprecationCallout;
const getLogsExplorerLinkProps = locator => {
  return (0, _routerUtils.getRouterLinkProps)({
    href: locator.getRedirectUrl({}),
    onClick: () => locator.navigate({})
  });
};
const calloutStyle = (0, _css.css)`
  margin-bottom: ${_uiTheme.euiThemeVars.euiSizeL};
`;