"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedInterval = void 0;
var React = _interopRequireWildcard(require("react"));
var _common = require("@kbn/kibana-react-plugin/common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HighlightedInterval = ({
  className,
  end,
  getPositionOfTime,
  start,
  targetWidth,
  width,
  target
}) => {
  const yStart = getPositionOfTime(start);
  const yEnd = getPositionOfTime(end);
  const yTarget = target && getPositionOfTime(target);
  return /*#__PURE__*/React.createElement(React.Fragment, null, yTarget && /*#__PURE__*/React.createElement(HighlightTargetMarker, {
    className: className,
    x1: 0,
    x2: targetWidth,
    y1: yTarget,
    y2: yTarget
  }), /*#__PURE__*/React.createElement(HighlightPolygon, {
    className: className,
    points: ` ${targetWidth},${yStart} ${width},${yStart} ${width},${yEnd}  ${targetWidth},${yEnd}`
  }));
};
exports.HighlightedInterval = HighlightedInterval;
HighlightedInterval.displayName = 'HighlightedInterval';
const HighlightTargetMarker = _common.euiStyled.line`
  stroke: ${props => props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;
const HighlightPolygon = _common.euiStyled.polygon`
  fill: ${props => props.theme.eui.euiColorPrimary};
  fill-opacity: 0.3;
  stroke: ${props => props.theme.eui.euiColorPrimary};
  stroke-width: 1;
`;