"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LensChart = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react2 = require("@emotion/react");
var _use_lens_attributes = require("../../hooks/use_lens_attributes");
var _lens_wrapper = require("./lens_wrapper");
var _chart_load_error = require("./chart_load_error");
var _constants = require("../../common/visualizations/constants");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MIN_HEIGHT = 300;
const LensChart = exports.LensChart = /*#__PURE__*/_react.default.memo(({
  id,
  borderRadius,
  dateRange,
  filters,
  hidePanelTitles,
  query,
  onBrushEnd,
  onFilter,
  overrides,
  toolTip,
  searchSessionId,
  disableTriggers = false,
  height = MIN_HEIGHT,
  loading = false,
  lensAttributes
}) => {
  const {
    formula,
    attributes,
    getExtraActions,
    error
  } = (0, _use_lens_attributes.useLensAttributes)(lensAttributes);
  const isLoading = loading || !attributes;
  const extraActions = getExtraActions({
    timeRange: dateRange,
    query,
    filters,
    searchSessionId
  });
  const handleBeforeBadgesRender = (0, _react.useCallback)(messages => {
    const missingFieldsMessage = messages.find(m => m.uniqueId === 'field_not_found' && m.severity === 'error');
    return missingFieldsMessage ? [{
      ...missingFieldsMessage,
      severity: 'warning',
      hidePopoverIcon: true,
      longMessage: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.lens.customErrorHandler.title",
        defaultMessage: "No results found"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "xs",
        "data-test-subj": "infraLensCustomErrorHanlderText"
      }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.lens.customErrorHandler.description",
        defaultMessage: "To display this chart, please ensure you are collecting the following fields:"
      })), /*#__PURE__*/_react.default.createElement("p", null, missingFieldsMessage && missingFieldsMessage.longMessage)), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
        margin: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": "infraLensCustomErrorHanlderLink",
        href: _constants.HOST_MISSING_FIELDS,
        target: "_blank"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.infra.customErrorHandler.learnMoreLink",
        defaultMessage: "Learn more"
      })))
    }] : messages;
  }, []);
  const lens = /*#__PURE__*/_react.default.createElement(_lens_wrapper.LensWrapper, {
    id: id,
    attributes: attributes,
    dateRange: dateRange,
    disableTriggers: disableTriggers,
    extraActions: extraActions,
    filters: filters,
    hidePanelTitles: hidePanelTitles,
    loading: isLoading,
    style: {
      height
    },
    query: query,
    overrides: overrides,
    onBrushEnd: onBrushEnd,
    searchSessionId: searchSessionId,
    onFilter: onFilter,
    onBeforeBadgesRender: handleBeforeBadgesRender
  });
  const content = !toolTip ? lens : /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    delay: "regular",
    content: /*#__PURE__*/_react.default.cloneElement(toolTip, {
      formula
    }),
    anchorClassName: "eui-fullWidth"
  }, /*#__PURE__*/_react.default.createElement("div", null, lens));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: !!borderRadius,
    borderRadius: borderRadius,
    hasShadow: false,
    paddingSize: error ? 'm' : 'none',
    "data-test-subj": id,
    css: (0, _react2.css)`
          position: relative;
          min-height: ${height}px;
          .embPanel-isLoading {
            min-height: ${height}px;
          }
        `
  }, error ? /*#__PURE__*/_react.default.createElement(_chart_load_error.ChartLoadError, {
    error: error
  }) : content);
});