"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Page = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_entity_centric_experience_setting = require("../../../hooks/use_entity_centric_experience_setting");
var _use_fetcher = require("../../../hooks/use_fetcher");
var _constants = require("../../../../common/constants");
var _use_metrics_breadcrumbs = require("../../../hooks/use_metrics_breadcrumbs");
var _use_parent_breadcrumb_resolver = require("../../../hooks/use_parent_breadcrumb_resolver");
var _use_kibana = require("../../../hooks/use_kibana");
var _constants2 = require("../constants");
var _content = require("../content/content");
var _use_asset_details_render_props = require("../hooks/use_asset_details_render_props");
var _use_metadata_state = require("../hooks/use_metadata_state");
var _use_page_header = require("../hooks/use_page_header");
var _use_tab_switcher = require("../hooks/use_tab_switcher");
var _utils = require("../utils");
var _infra_page_template = require("../../shared/templates/infra_page_template");
var _no_data_config = require("../../shared/templates/no_data_config");
var _page_title_with_popover = require("../header/page_title_with_popover");
var _use_entity_summary = require("../hooks/use_entity_summary");
var _get_data_stream_types = require("../utils/get_data_stream_types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DATA_AVAILABILITY_PER_TYPE = {
  host: [_constants.SYSTEM_INTEGRATION]
};
const Page = ({
  tabs = [],
  links = []
}) => {
  const {
    loading
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const {
    metadata,
    loading: metadataLoading
  } = (0, _use_metadata_state.useMetadataStateContext)();
  const {
    rightSideItems,
    tabEntries,
    breadcrumbs: headerBreadcrumbs
  } = (0, _use_page_header.usePageHeader)(tabs, links);
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  const trackOnlyOnce = _react.default.useRef(false);
  const {
    dataStreams,
    status: entitySummaryStatus
  } = (0, _use_entity_summary.useEntitySummary)({
    entityType: asset.type,
    entityId: asset.id
  });
  const {
    isEntityCentricExperienceEnabled
  } = (0, _use_entity_centric_experience_setting.useEntityCentricExperienceSetting)();
  const {
    activeTabId
  } = (0, _use_tab_switcher.useTabSwitcherContext)();
  const {
    services: {
      telemetry
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const parentBreadcrumbResolver = (0, _use_parent_breadcrumb_resolver.useParentBreadcrumbResolver)();
  const breadcrumbOptions = parentBreadcrumbResolver.getBreadcrumbOptions(asset.type);
  (0, _use_metrics_breadcrumbs.useMetricsBreadcrumbs)([{
    ...breadcrumbOptions.link,
    text: breadcrumbOptions.text
  }, {
    text: asset.name
  }]);
  (0, _react.useEffect)(() => {
    if (trackOnlyOnce.current) {
      return;
    }
    if (!metadataLoading && metadata) {
      const integrations = (0, _utils.getIntegrationsAvailable)(metadata);
      const telemetryParams = {
        componentName: _constants2.ASSET_DETAILS_PAGE_COMPONENT_NAME,
        assetType: asset.type,
        tabId: activeTabId
      };
      telemetry.reportAssetDetailsPageViewed(integrations.length > 0 ? {
        ...telemetryParams,
        integrations
      } : telemetryParams);
      trackOnlyOnce.current = true;
    }
  }, [activeTabId, asset.type, metadata, metadataLoading, telemetry]);
  const showPageTitleWithPopover = asset.type === 'host' && !(0, _get_data_stream_types.isMetricsSignal)(dataStreams);
  const shouldBypassOnboarding = isEntityCentricExperienceEnabled && ((0, _get_data_stream_types.isLogsSignal)(dataStreams) || (0, _get_data_stream_types.isMetricsSignal)(dataStreams));
  return /*#__PURE__*/_react.default.createElement(_infra_page_template.InfraPageTemplate, {
    onboardingFlow: (0, _use_fetcher.isPending)(entitySummaryStatus) || shouldBypassOnboarding ? undefined : asset.type === 'host' ? _no_data_config.OnboardingFlow.Hosts : _no_data_config.OnboardingFlow.Infra,
    dataAvailabilityModules: DATA_AVAILABILITY_PER_TYPE[asset.type] || undefined,
    pageHeader: {
      pageTitle: loading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
        size: "m"
      }) : showPageTitleWithPopover ? /*#__PURE__*/_react.default.createElement(_page_title_with_popover.PageTitleWithPopover, {
        name: asset.name
      }) : asset.name,
      tabs: tabEntries,
      rightSideItems,
      breadcrumbs: headerBreadcrumbs
    },
    "data-component-name": _constants2.ASSET_DETAILS_PAGE_COMPONENT_NAME,
    "data-asset-type": asset.type
  }, /*#__PURE__*/_react.default.createElement(_content.Content, null));
};
exports.Page = Page;