"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilterExplanationCallout = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _common = require("@kbn/metrics-data-access-plugin/common");
var _react2 = require("@emotion/react");
var _use_asset_details_render_props = require("../../hooks/use_asset_details_render_props");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FilterExplanationCallout = ({
  dashboardFilterAssetIdEnabled
}) => {
  const {
    asset
  } = (0, _use_asset_details_render_props.useAssetDetailsRenderPropsContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    size: "s",
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: dashboardFilterAssetIdEnabled ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.infra.customDashboards.filteredByCurrentAssetExplanation.tooltip', {
        defaultMessage: 'Filtered by'
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
        transparentBackground: true,
        css: (0, _react2.css)`
                        color: inherit;
                      `
      }, `${(0, _common.findInventoryFields)(asset.type).id}: ${asset.id}`)) : _i18n.i18n.translate('xpack.infra.customDashboards.notFilteredExplanation.tooltip', {
        defaultMessage: 'You can change this dashboard to filter by the {assetType} by editing the link for it',
        values: {
          assetType: asset.type
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      color: "primary",
      size: "m",
      type: "iInCircle"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, dashboardFilterAssetIdEnabled ? _i18n.i18n.translate('xpack.infra.customDashboards.filteredByCurrentAssetExplanation.message', {
      defaultMessage: 'This dashboard is filtered by the current {assetType}',
      values: {
        assetType: asset.type
      }
    }) : _i18n.i18n.translate('xpack.infra.customDashboards.notFilteredExplanation.message', {
      defaultMessage: 'This dashboard is not filtered by the {assetType} you are viewing',
      values: {
        assetType: asset.type
      }
    })))
  });
};
exports.FilterExplanationCallout = FilterExplanationCallout;