"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GotoDashboardLink = GotoDashboardLink;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_kibana = require("../../../../../hooks/use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function GotoDashboardLink({
  currentDashboard
}) {
  const {
    services: {
      dashboard: {
        locator: dashboardLocator
      }
    }
  } = (0, _use_kibana.useKibanaContextForPlugin)();
  const url = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
    dashboardId: currentDashboard === null || currentDashboard === void 0 ? void 0 : currentDashboard.dashboardSavedObjectId
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": "infraGotoDashboardGoToDashboardButton",
    color: "text",
    size: "s",
    iconType: "visGauge",
    href: url
  }, _i18n.i18n.translate('xpack.infra.customDashboards.contextMenu.goToDashboard', {
    defaultMessage: 'Go to dashboard'
  }));
}