"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Popover = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _reactHooks = require("@kbn/react-hooks");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Popover = ({
  children,
  icon,
  iconColor,
  iconSize,
  ...props
}) => {
  const [isPopoverOpen, {
    off: closePopover,
    toggle: togglePopover
  }] = (0, _reactHooks.useBoolean)(false);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "s",
    focusTrapProps: {
      returnFocus: false
    },
    button: /*#__PURE__*/_react2.default.createElement("button", {
      onClick: e => {
        e.stopPropagation();
        togglePopover();
      },
      css: (0, _react.css)`
            display: flex;
          `,
      "data-test-subj": props['data-test-subj']
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiIcon, {
      type: "questionInCircle",
      color: iconColor !== null && iconColor !== void 0 ? iconColor : 'text',
      size: iconSize !== null && iconSize !== void 0 ? iconSize : 'original'
    })),
    isOpen: isPopoverOpen,
    offset: 10,
    closePopover: closePopover,
    repositionOnScroll: true,
    anchorPosition: "upCenter",
    panelStyle: {
      maxWidth: 350
    }
  }, children);
};
exports.Popover = Popover;